"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupEntity = void 0;
const MatchDefine_1 = require("../../../kds-base-define/src/MatchDefine");
const GameSet_1 = require("../../../kds-base-define/src/GameSet");
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const log_1 = require("../log");
const SrsDefine_1 = require("../../../kds-base-define/src/SrsDefine");
const SrsUserMsg_1 = require("../../../kds-base-define/src/SrsUserMsg");
const _ = require("underscore");
const NotifyDefine_1 = require("../../../kds-base-define/src/NotifyDefine");
const RobotEntity_1 = require("./RobotEntity");
var GroupUserStatus;
(function (GroupUserStatus) {
    GroupUserStatus[GroupUserStatus["Wait"] = 0] = "Wait";
    GroupUserStatus[GroupUserStatus["Confirm"] = 1] = "Confirm";
    GroupUserStatus[GroupUserStatus["Playing"] = 2] = "Playing";
    GroupUserStatus[GroupUserStatus["Exiting"] = 3] = "Exiting";
})(GroupUserStatus || (GroupUserStatus = {}));
var ConfirmStatus;
(function (ConfirmStatus) {
    ConfirmStatus[ConfirmStatus["Wait"] = 0] = "Wait";
    ConfirmStatus[ConfirmStatus["Confirm"] = 1] = "Confirm";
    ConfirmStatus[ConfirmStatus["Abandon"] = 2] = "Abandon";
    ConfirmStatus[ConfirmStatus["Exit"] = 3] = "Exit";
})(ConfirmStatus || (ConfirmStatus = {}));
let confirmTimeout = 10000;
class GroupEntity {
    constructor(groupData) {
        this.data_ = null;
        this.robot_ = true;
        this.robotEntity_ = new RobotEntity_1.RobotEntity();
        this.users_ = [];
        this.confirms_ = [];
        this.updatePromise_ = null;
        this.prevUserCountTime_ = null;
        this.logicTime_ = 0;
        this.data_ = groupData;
        let gameData = groupData.gameData;
        this.gameSet_ = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
        let self = this;
        this.interval_ = setInterval(function () {
            if (self.updatePromise_) {
                return;
            }
            self.updatePromise_ = self.onUpdate();
            self.updatePromise_
                .then(function () {
                self.updatePromise_ = null;
            })
                .catch(function () {
                self.updatePromise_ = null;
            });
        }, 500);
    }
    get data() {
        return this.data_;
    }
    get groupID() {
        return this.data.groupID;
    }
    get matchID() {
        return this.data.matchID;
    }
    get matchEntity() {
        return rpc_1.Rpc.matchMgr.getMatchEntity(this.data.matchID);
    }
    get userCount() {
        return this.users_.length;
    }
    get gameSet() {
        return this.gameSet_;
    }
    get robot() {
        return (this.data.robot || false) && this.robot_;
    }
    set robot(v) {
        this.robot_ = v;
    }
    srsUserEnter(nodeH, loginData) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = {};
            do {
                let userID = loginData.userID;
                if (this.data.matchID) {
                    let match = rpc_1.Rpc.matchMgr.getMatchEntity(this.matchID);
                    let b = yield match.onUserEnterGroup(this.groupID, userID);
                    if (typeof (b) == "string") {
                        log_1.Log.oth.info("[group] cannot enter group groupID = " + this.groupID + " matchID = " + this.matchID + " userID = " + userID + " msg = " + b);
                        ret.errMsg = b;
                        break;
                    }
                }
                let nodeInfo = rpc_1.Rpc.center.getServerClientInfo(nodeH);
                if (nodeInfo == null) {
                    log_1.Log.oth.error("[group] user enter failed unknown nodeH userID = " + userID + " | nodeH = " + nodeH);
                    ret.errMsg = "进入失败";
                    break;
                }
                let userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", userID);
                if (userInfo == null) {
                    ret.errMsg = "进入失败";
                    break;
                }
                if (this.data.costType != MatchDefine_1.MatchDefine.CostType.Nothing) {
                    let useValue = 0;
                    switch (this.data.costType) {
                        case MatchDefine_1.MatchDefine.CostType.Diamond:
                            {
                                useValue = userInfo.diamondCount;
                            }
                            break;
                        case MatchDefine_1.MatchDefine.CostType.Gold:
                            {
                                useValue = userInfo.goldCount;
                            }
                            break;
                    }
                    log_1.Log.oth.info("[group] user enter userValue = " + useValue + " | groupID = " + this.groupID);
                    let data = this.data;
                    if (data.minCost != null && data.minCost >= 0) {
                        if (useValue < data.minCost) {
                            ret.errMsg = "进入失败: 金币不足";
                            break;
                        }
                    }
                    if (data.maxCost != null && data.maxCost >= 0) {
                        if (useValue > data.maxCost) {
                            ret.errMsg = "进入失败: 金币数量超过最大限制";
                            break;
                        }
                    }
                    if (useValue < data.roomCost) {
                        ret.errMsg = "进入失败: 金币不足";
                        break;
                    }
                }
                let record = yield rpc_1.Rpc.center.callException("kds.dbp.user.gamerecord.get", loginData.userID, this.groupID);
                if (record == null) {
                    record = {
                        totalCount: 0,
                        win: 0,
                        lose: 0,
                        draw: 0,
                        escape: 0,
                    };
                }
                log_1.Log.oth.info("[group] user enter userID = " + userID);
                log_1.Log.oth.info("[group] srs info = ", nodeInfo);
                log_1.Log.oth.info("[group] record = ", record);
                this.users_.push({
                    userID: userID,
                    loginData: loginData,
                    status: GroupUserStatus.Wait,
                    enterTime: utils_1.kdutils.getMillionSecond(),
                    nodeInfo: nodeInfo,
                    userInfo: userInfo,
                    record: record,
                });
                ret.groupID = this.groupID;
            } while (false);
            return ret;
        });
    }
    isUserExist(userID) {
        return this.users_.find(v => v.userID == userID) != null;
    }
    userExit(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.doUserExit(userID);
        });
    }
    srsUserExit(nodeH, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let user = this.users_.find(v => v.userID == userID);
            if (user == null) {
                return false;
            }
            let nodeInfo = rpc_1.Rpc.center.getServerClientInfo(nodeH);
            if (nodeInfo == null) {
                log_1.Log.oth.error("[group] user exit failed unknown nodeH userID = " + userID + " | nodeH = " + nodeH);
                log_1.Log.oth.info("[group] continue exit");
            }
            else {
                if (user.nodeInfo.name != nodeInfo.name) {
                    log_1.Log.oth.error("[group] user exit failed call srs = " + nodeInfo.name + " | user node name = " + user.nodeInfo.name + " | user id = " + user.userID);
                    return false;
                }
            }
            return yield this.doUserExit(userID, true);
        });
    }
    srsUserConfirm(userID, b) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.doUserConfirm(userID, b);
        });
    }
    removeAllUsers() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    onRelease() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.interval_) {
                clearInterval(this.interval_);
                this.interval_ = null;
                yield this.removeAllUsers();
            }
        });
    }
    sendToUser(userID, msgName, jsonObj) {
        let user = this.users_.find(v => v.userID == userID);
        if (user == null) {
            return false;
        }
        rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(user.nodeInfo.name) +
            ".sendToUser", userID, msgName, jsonObj);
        return true;
    }
    doUserExit(userID, srsCall) {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[doUserExit] userID = " + userID);
            let idx = this.users_.findIndex(v => v.userID == userID);
            if (idx < 0) {
                log_1.Log.oth.info("[doUserExit] user already not exist");
                return true;
            }
            let user = this.users_[idx];
            // if(user.status != GroupUserStatus.Wait) {
            // 	if(user.status == GroupUserStatus.Confirm) {
            // 		let b = await this.doUserExitConfirm(userID)
            // 		if(b) {
            // 			return true 
            // 		}
            // 	}
            // }
            if (yield this.doUserExitConfirm(userID)) {
                log_1.Log.oth.info("[doUserExit] call doUserExitConfirm true");
                return true;
            }
            user.status = GroupUserStatus.Exiting;
            // srs发起的enter不会再call回srs
            // 反之group匹配失败后的exit要通知srs，srs会发送失败信息给玩家
            if (!srsCall) {
                rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(user.nodeInfo.name) +
                    ".userExitGroup", user.userID, this.groupID);
            }
            idx = this.users_.findIndex(v => v.userID == userID);
            if (idx < 0) {
                log_1.Log.oth.info("[doUserExit] user already not exist 2");
                return true;
            }
            this.users_.splice(idx, 1);
            log_1.Log.oth.info("[doUserExit] user exit success");
            return true;
        });
    }
    getConfirmByUser(userID) {
        let data = this.confirms_.find(v => v.users.find(vv => vv.userID == userID) != null);
        return data;
    }
    doUserConfirm(userID, b) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = this.getConfirmByUser(userID);
            if (data == null) {
                return false;
            }
            let user = data.users.find(v => v.userID == userID);
            if (user.status != ConfirmStatus.Wait) {
                return true;
            }
            log_1.Log.oth.info("[confirm] receive user confirm userID = " + userID + " | b = " + b);
            let t = {
                userID: userID,
                confirm: false,
            };
            if (b) {
                user.status = ConfirmStatus.Confirm;
                t.confirm = true;
            }
            else {
                user.status = ConfirmStatus.Abandon;
                t.confirm = false;
            }
            for (let user of data.users) {
                this.sendToUser(user.userID, SrsUserMsg_1.SrsUserNotify.ConfirmUserReady, t);
            }
            return true;
        });
    }
    doUserExitConfirm(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = this.getConfirmByUser(userID);
            if (data == null) {
                return false;
            }
            let user = data.users.find(v => v.userID == userID);
            log_1.Log.oth.info("[confirm] user exit confirm userID = " + userID);
            let t = {
                userID: userID,
                confirm: false,
            };
            user.status = ConfirmStatus.Exit;
            t.confirm = false;
            for (let user of data.users) {
                this.sendToUser(user.userID, SrsUserMsg_1.SrsUserNotify.ConfirmUserReady, t);
            }
            return true;
        });
    }
    onRoomEnd(roomPOData, roomRealtime, bill) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.data.matchID) {
                let entity = this.matchEntity;
                if (entity == null) {
                    log_1.Log.oth.info("[roomEnd] cannot get match entity", bill);
                    return;
                }
                yield entity.onRoomEnd(roomPOData, roomRealtime, bill);
            }
            yield this.removeRoomID(roomPOData.roomID);
        });
    }
    _getGroupCacheTableName() {
        return "t_group_rooms_" + this.groupID;
    }
    addRoomID(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", this._getGroupCacheTableName(), roomID.toString(), true);
        });
    }
    removeRoomID(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.delt", this._getGroupCacheTableName(), roomID.toString());
        });
    }
    getAllRoomIDs() {
        return __awaiter(this, void 0, void 0, function* () {
            let kv = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gettAll", this._getGroupCacheTableName());
            if (kv) {
                let ret = [];
                for (let key of Object.keys(kv)) {
                    ret.push(Number.parseInt(key));
                }
                return ret;
            }
            return [];
        });
    }
    getUserEnterTime(userID) {
        let user = this.users_.find(v => v.userID == userID);
        return user ? user.enterTime : null;
    }
    onUpdate() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.updatePromise_) {
                return;
            }
            let time = utils_1.kdutils.getMillionSecond();
            let sendUserCount = false;
            if (this.prevUserCountTime_ == null) {
                sendUserCount = true;
            }
            else {
                if (time - this.prevUserCountTime_ >= 2500) {
                    sendUserCount = true;
                }
            }
            if (sendUserCount) {
                this.prevUserCountTime_ = time;
                let t = {
                    changeName: NotifyDefine_1.NotifyUser.Change_GroupUserCount,
                    data: {
                        groupID: this.groupID,
                        userCount: this.userCount,
                    }
                };
                for (let user of this.users_) {
                    if (user.status != GroupUserStatus.Wait) {
                        continue;
                    }
                    this.sendToUser(user.userID, NotifyDefine_1.NotifyUser.MsgName, t);
                }
            }
            let logic = this.data.logic;
            let delayTime = this.data.delayTime || 0;
            try {
                let users = [];
                let userIDs = [];
                for (let user of this.users_) {
                    if (time - user.enterTime < delayTime) {
                        continue;
                    }
                    if (user.status == GroupUserStatus.Wait) {
                        users.push(user);
                        userIDs.push(user.userID);
                    }
                }
                if (logic && logic.type == MatchDefine_1.MatchDefine.LogicType.WaitTimeout) {
                    if (this.logicTime_ == 0) {
                        log_1.Log.oth.info("[group-logic] init time");
                        this.logicTime_ = time;
                        users = [];
                    }
                    else if (users.length == 0) {
                        this.logicTime_ = time;
                    }
                    else {
                        if (time - this.logicTime_ < logic.time) {
                            if (users.length < logic.count) {
                                users = [];
                            }
                            else {
                                this.logicTime_ = time;
                            }
                        }
                        else {
                            this.logicTime_ = time;
                        }
                    }
                }
                let mates = null;
                if (this.matchEntity) {
                    mates = this.matchEntity.createGroupMates(userIDs);
                }
                if (mates) {
                    for (let i = mates.length - 1; i >= 0; i--) {
                        let userIDs = mates[i];
                        for (let userID of userIDs) {
                            let user = this.users_.find(v => v.userID == userID);
                            if (user == null) {
                                log_1.Log.oth.info("[group] cannot find user in mate userID = " + userID + " mates = ", userIDs);
                                mates.splice(i, 1);
                                break;
                            }
                        }
                    }
                    users.splice(0);
                }
                mates = mates || [];
                // for(let i = users.length - 1 ; i >= 0 ; i --) {
                // 	let userID = users[i].userID
                // 	for(let userIDs of mates) {
                // 		if(userIDs.includes(userID)) {
                // 			users.splice(i,1)
                // 			break 
                // 		}
                // 	}
                // }
                users = _.shuffle(users);
                let idx = 0;
                let mateIdx = 0;
                let length = users.length;
                let userCount = this.gameSet_.getUserCount();
                // Log.oth.info("房间this.data.ignoreConfirm => ", JSON.stringify(this.data.ignoreConfirm));
                // Log.oth.info("房间this.robot => ", JSON.stringify(this.robot));
                // Log.oth.info("房间length => ", JSON.stringify(length));
                // Log.oth.info("房间users.length => ", JSON.stringify(users.length));
                // Log.oth.info("=========================================================");
                if (length != 0 && this.data.ignoreConfirm && this.robot) {
                    this.robotEntity_.setActive(5);
                    if (this.robotEntity_.isActive) {
                        // 向人数对齐
                        if (length % userCount != 0) {
                            length = Math.ceil(length / userCount) * userCount;
                        }
                    }
                }
                if (length == 0) {
                    if (this.robotEntity_.isActive) {
                        this.robotEntity_.setInactive();
                    }
                }
                log_1.Log.oth.info("mateIdx => ", mateIdx, mates.length, users.length, idx);
                while ((mateIdx < mates.length) || (users.length - idx >= this.gameSet_.getUserCount())) {
                    let confirm = {
                        users: [],
                        startTime: utils_1.kdutils.getMillionSecond(),
                    };
                    let t = {
                        groupID: this.groupID,
                        timeout: confirmTimeout,
                        users: []
                    };
                    let useMate = null;
                    if (mateIdx < mates.length) {
                        useMate = mates[mateIdx];
                    }
                    for (let i = 0; i < userCount; i++) {
                        let chairNo = i;
                        let user;
                        if (useMate) {
                            user = this.users_.find(v => v.userID == useMate[i]);
                        }
                        else {
                            user = users[idx + i];
                        }
                        log_1.Log.oth.info("user => " + user);
                        if (user) {
                            user.status = GroupUserStatus.Confirm;
                            confirm.users.push({
                                userID: user.userID,
                                status: ConfirmStatus.Wait,
                                chairNo: chairNo
                            });
                            let winRate = 0;
                            if (user.record.totalCount > 0) {
                                winRate = Math.floor(user.record.win / user.record.totalCount * 100);
                            }
                            let escapeRate = 0;
                            if (user.record.totalCount > 0) {
                                escapeRate = Math.floor(user.record.escape / user.record.totalCount * 100);
                            }
                            log_1.Log.oth.info("userID = " + user.userID, user.record);
                            t.users.push({
                                userID: user.userID,
                                nickName: user.loginData.nickName,
                                iconUrl: user.loginData.iconUrl,
                                chairNo: chairNo,
                                totalCount: user.record.totalCount,
                                winRate: winRate,
                                escapeRate: escapeRate,
                            });
                        }
                        else {
                            if (this.robot) {
                                confirm.users.push({
                                    userID: -1,
                                    status: ConfirmStatus.Confirm,
                                    chairNo: chairNo
                                });
                                log_1.Log.oth.info("prepare robot");
                            }
                            else {
                                log_1.Log.oth.info("user idx out of length = " + length + " idx = " + (idx + i));
                                break;
                            }
                        }
                    }
                    if (!this.data.ignoreConfirm) {
                        for (let user of confirm.users) {
                            this.sendToUser(user.userID, SrsUserMsg_1.SrsUserNotify.ConfirmGroupStart, t);
                        }
                    }
                    this.confirms_.push(confirm);
                    if (mateIdx < mates.length) {
                        mateIdx++;
                    }
                    else {
                        idx += userCount;
                    }
                }
            }
            catch (error) {
                log_1.Log.oth.error("[group] update error id = " + this.groupID, error);
            }
            yield this.onUpdateConfirms();
        });
    }
    onUpdateConfirms() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.confirms_.length == 0) {
                return;
            }
            let time = utils_1.kdutils.getMillionSecond();
            let confirms = this.confirms_.slice(0);
            for (let confirmData of confirms) {
                let flag = 0; // 0 成功 1 错误 2 等待 
                let failedUserID = 0;
                let failedExit = false;
                let users = [];
                let robotUserIDs = null;
                do {
                    try {
                        let allConfirm = true;
                        let abandon = false;
                        for (let user of confirmData.users) {
                            let data = user.userID >= 0 ? this.users_.find(v => v.userID == user.userID) : null;
                            if (this.data.ignoreConfirm) {
                                users.push(data);
                                continue;
                            }
                            if (data) {
                                users.push(data);
                                if (user.status == ConfirmStatus.Abandon) {
                                    abandon = true;
                                    failedUserID = user.userID;
                                    break;
                                }
                                else if (user.status == ConfirmStatus.Exit) {
                                    log_1.Log.oth.info("[confirm-update] user exit userID = " + user.userID);
                                    abandon = true;
                                    failedUserID = user.userID;
                                    failedExit = true;
                                    break;
                                }
                                else if (user.status == ConfirmStatus.Wait) {
                                    allConfirm = false;
                                }
                                else if (user.status == ConfirmStatus.Confirm) {
                                }
                                else {
                                    log_1.Log.oth.info("unknown confirm status value = " + user.status);
                                    abandon = true;
                                    failedUserID = user.userID;
                                    failedExit = true;
                                }
                            }
                            else {
                                abandon = true;
                                failedUserID = user.userID;
                                failedExit = true;
                                break;
                            }
                        }
                        // 有人拒绝，重新匹配
                        if (abandon) {
                            // 抛弃
                            flag = 1;
                            break;
                        }
                        // 有人掉线了
                        if (users.length != confirmData.users.length) {
                            // 抛弃
                            flag = 1;
                            break;
                        }
                        // 没有全部确认
                        if (!allConfirm) {
                            // 没有超时
                            if (time - confirmData.startTime < confirmTimeout) {
                                // 继续
                                flag = 2;
                                break;
                            }
                            // 超时相当于全部确认
                        }
                        let roomFlag = "group|" + this.groupID;
                        let roomData = null;
                        try {
                            roomData = yield rpc_1.Rpc.center.callException("kds.room.create.internal", roomFlag, this.data.gameData, this.groupID);
                            log_1.Log.oth.info("[group] create room groupID = " + this.groupID + " | id = " + roomData.roomID);
                        }
                        catch (error) {
                            log_1.Log.oth.error("[group] create room failed id = " + this.groupID);
                        }
                        if (roomData == null) {
                            throw new Error("fail to create room ");
                        }
                        let allSuccess = true;
                        let robotCount = users.filter(v => v == null).length;
                        log_1.Log.oth.info("[group] users = ", JSON.stringify(users));
                        let robotIdx = 0;
                        if (robotCount > 0) {
                            log_1.Log.oth.info("[group] get robot count = " + robotCount);
                            robotUserIDs = yield rpc_1.Rpc.center.callException("kds.robot.getRobots", this.data, robotCount);
                            log_1.Log.oth.info("[group] get robot userIDs = " + JSON.stringify(robotUserIDs));
                            if (robotUserIDs && robotUserIDs.length == 0) {
                                robotUserIDs = null;
                            }
                        }
                        for (let i = 0; i < users.length; i++) {
                            let user = users[i];
                            let confirmUser = confirmData.users[i];
                            let b = false;
                            if (user) {
                                try {
                                    b = yield rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(user.nodeInfo.name) +
                                        ".userEnterRoomFromGroup", user.userID, this.groupID, roomData.roomID, confirmUser.chairNo);
                                }
                                catch (error) {
                                    log_1.Log.oth.error("[group] user enter failed userID = " + user.userID + " | roomID = " + roomData.roomID);
                                    log_1.Log.oth.error("error = ", error);
                                }
                                if (!b) {
                                    failedUserID = user.userID;
                                    allSuccess = false;
                                    break;
                                }
                            }
                            else {
                                // robot
                                let robotUserID = robotUserIDs[robotIdx++];
                                if (robotUserID == null) {
                                    log_1.Log.oth.error("[group] cannot get enough robot");
                                    allSuccess = false;
                                    failedUserID = -1;
                                }
                                let params = {
                                    userID: robotUserID,
                                    chairNo: confirmUser.chairNo,
                                    groupID: this.groupID,
                                    roomID: roomData.roomID
                                };
                                try {
                                    b = yield rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.NodeSide.robotEnter, params);
                                }
                                catch (error) {
                                    log_1.Log.oth.error("[group] robot enter failed userID = " + robotUserID + " | roomID = " + roomData.roomID);
                                    log_1.Log.oth.error("error = ", error);
                                }
                                if (!b) {
                                    failedUserID = robotUserID;
                                    allSuccess = false;
                                    break;
                                }
                            }
                        }
                        if (!allSuccess) {
                            log_1.Log.oth.info("[group] enter room failed release room groupID = " + this.groupID + " | id = " + roomData.roomID);
                            yield rpc_1.Rpc.center.callException("kds.srs.center.jiesanRoom", roomData.roomID);
                            yield rpc_1.Rpc.center.callException("kds.room.removeInternal", roomData.roomID);
                            flag = 1;
                            failedExit = true;
                        }
                        else {
                            flag = 0;
                            this.addRoomID(roomData.roomID);
                        }
                    }
                    catch (error) {
                        flag = 1;
                        log_1.Log.oth.error("[confirm] error in create room error = ", error);
                    }
                } while (false);
                if (flag == 2) {
                    continue;
                }
                log_1.Log.oth.info("[confirm] flag = " + flag);
                let idx = this.confirms_.indexOf(confirmData);
                if (idx >= 0) {
                    log_1.Log.oth.info("[confirm] match success idx = " + idx, confirmData);
                    this.confirms_.splice(idx, 1);
                }
                if (flag == 0) {
                    // 成功
                    for (let user of confirmData.users) {
                        if (user.userID >= 0) {
                            this.doUserExit(user.userID, true);
                        }
                    }
                }
                else if (flag == 1) {
                    if (robotUserIDs) {
                        rpc_1.Rpc.center.callException("kds.robot.unused", robotUserIDs);
                    }
                    let isRobot = robotUserIDs && robotUserIDs.includes(failedUserID);
                    // 错误
                    log_1.Log.oth.info("[confirm] fail match userID = " + failedUserID);
                    if (failedUserID >= 0 && failedExit && !isRobot) {
                        this.userExit(failedUserID);
                    }
                    let t = {
                        success: false,
                        groupID: this.groupID,
                        failedUserID: failedUserID,
                        continue: true
                    };
                    for (let user of confirmData.users) {
                        if (user.userID == failedUserID && failedExit) {
                            continue;
                        }
                        let userData = this.users_.find(v => v.userID == user.userID);
                        if (userData == null) {
                            continue;
                        }
                        userData.status = GroupUserStatus.Wait;
                        userData.enterTime = utils_1.kdutils.getMillionSecond();
                        this.sendToUser(user.userID, SrsUserMsg_1.SrsUserNotify.ConfirmGroupEnd, t);
                    }
                }
            } // for
        });
    }
}
exports.GroupEntity = GroupEntity;
