"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupHelper = void 0;
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const SrsDefine_1 = require("../../../kds-base-define/src/SrsDefine");
const UserFlag_1 = require("../../../kds-base-define/src/UserFlag");
var GroupHelper;
(function (GroupHelper) {
    function getRoomPOData(codeOrID) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let roomPOData = yield rpc_1.Rpc.center.callException("kds.dbp.room.get", codeOrID);
                return roomPOData;
            }
            catch (error) {
                log_1.Log.oth.error("gs: cannot get roomPOData from dbp error codeOrID = " + codeOrID, error);
            }
            return null;
        });
    }
    GroupHelper.getRoomPOData = getRoomPOData;
    function getRoomRealtime(codeOrID) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let roomRealtime = yield rpc_1.Rpc.center.callException("kds.dbp.room.real.get", codeOrID);
                return roomRealtime;
            }
            catch (error) {
                log_1.Log.oth.error("gs: cannot get roomRealtime from dbp error", error);
            }
            return null;
        });
    }
    GroupHelper.getRoomRealtime = getRoomRealtime;
    function updateRoomRealtime(roomRealtime) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let b = yield rpc_1.Rpc.center.callException("kds.dbp.room.real.update", roomRealtime);
                return b ? true : false;
            }
            catch (error) {
                log_1.Log.oth.error("gs: cannot update roomRealtime from dbp error", error);
            }
            return false;
        });
    }
    GroupHelper.updateRoomRealtime = updateRoomRealtime;
    function getUserFlag(userID, flag) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let value = yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.get", userID, flag);
                return value;
            }
            catch (error) {
                log_1.Log.oth.error("[handle] get user flag failed userID = " + userID, error);
            }
            return null;
        });
    }
    GroupHelper.getUserFlag = getUserFlag;
    function setUserFlag(userID, flag, value) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.set", userID, flag, value);
        });
    }
    GroupHelper.setUserFlag = setUserFlag;
    function removeUserFlag(userID, flag) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.remove", userID, flag);
        });
    }
    GroupHelper.removeUserFlag = removeUserFlag;
    // 查询玩家所在的房间，包括自己创建的房间和在线的房间
    function getUserRoomID(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomID = yield rpc_1.Rpc.center.callException("kds.dbp.room.boss", userID);
            if (roomID) {
                return roomID;
            }
            roomID = yield getUserFlag(userID, UserFlag_1.UserFlag.RoomID);
            return roomID;
        });
    }
    GroupHelper.getUserRoomID = getUserRoomID;
    function getUserNodeName(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.user.node.get", userID);
        });
    }
    GroupHelper.getUserNodeName = getUserNodeName;
    function toRoomID(codeOrID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (codeOrID) == "string") {
                return yield rpc_1.Rpc.center.callException("kds.dbp.room.id", codeOrID);
            }
            return codeOrID;
        });
    }
    GroupHelper.toRoomID = toRoomID;
    /**
     *
     * @param gameData
     * @param userIDs
     * @param opt
     * @returns number: failed userID | false: failed | true: success
     */
    function createGroupRoom(gameData, userIDs, opt) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomFlag = null;
            if (opt.groupID) {
                roomFlag = "group|" + this.groupID;
            }
            else {
                roomFlag = "match|" + this.matchID;
            }
            let roomData = null;
            try {
                if (opt.groupID) {
                    roomData = yield rpc_1.Rpc.center.callException("kds.room.create.internal", roomFlag, gameData, opt.groupID);
                    log_1.Log.oth.info("[group-helper] create room groupID = " + opt.groupID + " | id = " + roomData.roomID);
                }
                else {
                    roomData = yield rpc_1.Rpc.center.callException("kds.room.create.match", roomFlag, gameData, opt.matchID);
                    log_1.Log.oth.info("[group-helper] create room matchID = " + opt.matchID + " | id = " + roomData.roomID);
                }
            }
            catch (error) {
                log_1.Log.oth.error("[group-helper] create room failed opt = ", opt);
            }
            if (roomData == null) {
                return false;
            }
            log_1.Log.oth.info("[group-helper] start to enter room id = " + roomData.roomID);
            log_1.Log.oth.info("users = " + JSON.stringify(userIDs));
            if (userIDs.length == 0) {
                return true;
            }
            let allSuccess = true;
            let failedUserID = -1;
            let nodeMethodName = "userEnterRoomFromGroup";
            if (opt.matchID) {
                nodeMethodName = "userEnterRoomFromMatch";
            }
            for (let i = 0; i < userIDs.length; i++) {
                let userID = userIDs[i];
                let chairNo = opt.chairNos ? opt.chairNos[i] : -1;
                chairNo = chairNo == null ? -1 : chairNo;
                let b = false;
                try {
                    let nodeName = yield getUserNodeName(userID);
                    if (opt.groupID) {
                        if (nodeName == null) {
                            log_1.Log.oth.error("[group-helper] cannot get user node name user id = " + userID);
                        }
                        else {
                            b = yield rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(nodeName) +
                                ".userEnterRoomFromGroup", userID, opt.groupID, roomData.roomID, chairNo);
                        }
                    }
                    else {
                        if (nodeName == null) {
                            log_1.Log.oth.error("[group-helper] cannot get user node name user id = " + userID);
                            b = yield rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.NodeSide.userEnterRoomFromMatch, userID, opt.matchID, roomData.roomID, chairNo);
                        }
                        else {
                            b = yield rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(nodeName) +
                                ".userEnterRoomFromMatch", userID, opt.matchID, roomData.roomID, chairNo);
                        }
                    }
                }
                catch (error) {
                    log_1.Log.oth.error("[group-helper] user enter failed userID = " + userID + " | roomID = " + roomData.roomID + " | chairNo = " + chairNo);
                    log_1.Log.oth.error("error = ", error);
                }
                if (!b) {
                    failedUserID = userID;
                    allSuccess = false;
                    break;
                }
                else {
                    log_1.Log.oth.info("[group-helper] user enter success userID = " + userID + " | roomID = " + roomData.roomID);
                }
            }
            if (!allSuccess) {
                log_1.Log.oth.info("[group-helper] enter room failed release room groupID = " + opt.groupID || opt.matchID + " | id = " + roomData.roomID);
                yield rpc_1.Rpc.center.callException("kds.srs.center.jiesanRoom", roomData.roomID);
                yield rpc_1.Rpc.center.callException("kds.room.removeInternal", roomData.roomID);
                return failedUserID;
            }
            return true;
        });
    }
    GroupHelper.createGroupRoom = createGroupRoom;
})(GroupHelper = exports.GroupHelper || (exports.GroupHelper = {}));
