"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupManager = void 0;
const GroupEntity_1 = require("./GroupEntity");
const async_1 = require("kdweb-core/lib/tools/async");
const utils_1 = require("kdweb-core/lib/utils");
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const LoopEntity_1 = require("../helper/LoopEntity");
class GroupManager {
    constructor() {
        this.groups_ = [];
        this.creating_ = false;
    }
    srsUserEnter(nodeH, loginData, groupID) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = {};
            do {
                let group = this.getUserGroup(loginData.userID);
                if (group) {
                    if (group.groupID == groupID) {
                        ret.groupID = group.groupID;
                        break;
                    }
                    if (!(yield group.userExit(loginData.userID))) {
                        ret.groupID = group.groupID;
                        break;
                    }
                }
                group = yield this.getGroupEntity(groupID);
                if (group == null) {
                    ret.errMsg = "没有找到房间";
                    break;
                }
                ret = yield group.srsUserEnter(nodeH, loginData);
            } while (false);
            return ret;
        });
    }
    addGroupByMatch(matchData) {
        return __awaiter(this, void 0, void 0, function* () {
            if (matchData.groupData == null) {
                return false;
            }
            let entity = this.groups_.find(v => v.groupID == matchData.groupData.groupID);
            if (entity) {
                return true;
            }
            entity = new GroupEntity_1.GroupEntity(matchData.groupData);
            this.groups_.push(entity);
            return true;
        });
    }
    removeGroupByMatch(matchData) {
        return __awaiter(this, void 0, void 0, function* () {
            let idx = this.groups_.findIndex(v => v.groupID == matchData.groupData.groupID);
            if (idx < 0) {
                return true;
            }
            let entity = this.groups_[idx];
            if (entity) {
                yield entity.onRelease();
                this.groups_.splice(idx, 1);
            }
            return true;
        });
    }
    removeGroup(groupID) {
        return __awaiter(this, void 0, void 0, function* () {
            let idx = this.groups_.findIndex(v => v.groupID == groupID);
            if (idx < 0) {
                return true;
            }
            let entity = this.groups_[idx];
            if (entity) {
                yield entity.onRelease();
                this.groups_.splice(idx, 1);
            }
            return true;
        });
    }
    userExit(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let group = this.getUserGroup(userID);
            if (group == null) {
                return true;
            }
            return yield group.userExit(userID);
        });
    }
    srsUserExit(nodeH, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let group = this.getUserGroup(userID);
            if (group == null) {
                return true;
            }
            return yield group.srsUserExit(nodeH, userID);
        });
    }
    srsUserConfirm(userID, b) {
        return __awaiter(this, void 0, void 0, function* () {
            let group = this.getUserGroup(userID);
            if (group == null) {
                return false;
            }
            return yield group.srsUserConfirm(userID, b);
        });
    }
    getUserGroupID(userID) {
        let group = this.groups_.find(v => v.isUserExist(userID));
        if (group) {
            return group.groupID;
        }
        return null;
    }
    getUserGroup(userID) {
        return this.groups_.find(v => v.isUserExist(userID));
    }
    getGroupUserCount(groupID) {
        let group = this.groups_.find(v => v.groupID == groupID);
        return group ? group.userCount : 0;
    }
    getGroupActiveUserCount(groupID) {
        if (groupID == 66000002) {
            return LoopEntity_1.loopEntity.activeUserCount;
        }
        let userCount = LoopEntity_1.loopEntity.activeUserCount;
        if (userCount == 0) {
            return userCount;
        }
        let base = Math.floor(userCount / 2);
        let range = Math.ceil(base / 4);
        base += (Math.floor((Math.random() * userCount) % (range * 2)) - range);
        return base > 0 ? base : 0;
    }
    getGroupGameActiveUserCount(gameID) {
        return 100;
    }
    getGroupEntitySync(groupID) {
        return this.groups_.find(v => v.groupID == groupID);
    }
    getGroupEntity(groupID) {
        return __awaiter(this, void 0, void 0, function* () {
            let group = this.groups_.find(v => v.groupID == groupID);
            if (group) {
                return group;
            }
            if (this.creating_) {
                let startTime = utils_1.kdutils.getMillionSecond();
                while (true) {
                    yield async_1.kdasync.timeout(100);
                    if (!this.creating_) {
                        break;
                    }
                    if (utils_1.kdutils.getMillionSecond() - startTime > 5000) {
                        return null;
                    }
                }
                group = this.groups_.find(v => v.groupID == groupID);
                if (group) {
                    return group;
                }
            }
            this.creating_ = true;
            let ret = null;
            do {
                let groupData = null;
                try {
                    groupData = yield rpc_1.Rpc.center.callException("kds.dbp.group.get", groupID);
                }
                catch (error) {
                    log_1.Log.oth.info("[mgr] get group data failed id = " + groupID);
                    break;
                }
                if (groupData == null) {
                    log_1.Log.oth.info("[mgr] cannot create group id = " + groupID);
                    break;
                }
                if (!groupData.enabled) {
                    log_1.Log.oth.info("[mgr] cannot create group disabled id = " + groupID);
                    break;
                }
                ret = new GroupEntity_1.GroupEntity(groupData);
            } while (false);
            this.creating_ = false;
            if (ret) {
                this.groups_.push(ret);
                return ret;
            }
            return null;
        });
    }
    getRobotEnabled(groupID) {
        let group = this.getGroupEntitySync(groupID);
        return group ? group.robot : false;
    }
    setRobotEnabled(groupID, b) {
        let group = this.getGroupEntitySync(groupID);
        if (group) {
            group.robot = b;
            return true;
        }
        return false;
    }
}
exports.GroupManager = GroupManager;
