"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RobotEntity = exports.RobotStatus = void 0;
const utils_1 = require("kdweb-core/lib/utils");
var RobotStatus;
(function (RobotStatus) {
    RobotStatus[RobotStatus["None"] = 0] = "None";
    RobotStatus[RobotStatus["Wait"] = 1] = "Wait";
    RobotStatus[RobotStatus["Active"] = 2] = "Active";
})(RobotStatus = exports.RobotStatus || (exports.RobotStatus = {}));
class RobotEntity {
    constructor() {
        this.status_ = RobotStatus.None;
        this.waitStartTime_ = 0;
        this.delayTime_ = 0;
        let self = this;
        setInterval(function () {
            self.onUpdate();
        }, 100);
    }
    get status() {
        return this.status_;
    }
    set status(v) {
        this.status_ = v;
    }
    get isActive() {
        return this.status == RobotStatus.Active;
    }
    setActive(delaySec) {
        delaySec = delaySec || 0;
        if (this.status != RobotStatus.None) {
            return;
        }
        if (delaySec <= 0) {
            this.status = RobotStatus.Active;
        }
        else {
            this.status = RobotStatus.Wait;
            this.waitStartTime_ = utils_1.kdutils.getMillionSecond();
            this.delayTime_ = delaySec * 1000;
        }
    }
    setInactive() {
        this.status = RobotStatus.None;
    }
    onUpdate() {
        if (this.status == RobotStatus.Wait) {
            let time = utils_1.kdutils.getMillionSecond();
            if (time - this.waitStartTime_ >= this.delayTime_) {
                this.status = RobotStatus.Active;
            }
        }
    }
}
exports.RobotEntity = RobotEntity;
