"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.loopEntity = void 0;
const rpc_1 = require("../rpc");
const log_1 = require("../log");
class LoopEntity {
    constructor() {
        this.activeUserCount_ = 0;
        this.working_ = false;
        let self = this;
        setInterval(function () {
            self.onUpdate();
        }, 100000);
    }
    get activeUserCount() {
        return this.activeUserCount_;
    }
    set activeUserCount(v) {
        this.activeUserCount_ = v;
    }
    onUpdate() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.working_) {
                return;
            }
            this.working_ = true;
            try {
                let userCount = yield rpc_1.Rpc.center.callException("kds.dbp.user.node.count");
                if (userCount != null) {
                    this.activeUserCount_ = userCount;
                    if (this.activeUserCount < 0) {
                        this.activeUserCount = 0;
                    }
                }
            }
            catch (error) {
                log_1.Log.oth.error("[loop] get srs user count failed error = ", error);
            }
            this.working_ = false;
        });
    }
}
exports.loopEntity = new LoopEntity();
