"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchBase = void 0;
const MatchDefine_1 = require("../../../kds-base-define/src/MatchDefine");
const log_1 = require("../log");
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const async_1 = require("kdweb-core/lib/tools/async");
const MatchHelper_1 = require("./MatchHelper");
const RoomDefine_1 = require("../../../kds-base-define/src/RoomDefine");
const GroupHelper_1 = require("../group/GroupHelper");
const KVDefine_1 = require("../../../kds-base-define/src/KVDefine");
const ItemDefine_1 = require("../../../kds-base-define/src/ItemDefine");
const MatchExtensions_1 = require("../../../kds-base-define/src/MatchExtensions");
class MatchBase {
    constructor(data) {
        this.data_ = null;
        this.r_ = null;
        this.prevRankTime_ = -1;
        this.ranking_ = false;
        this.rankDirty_ = true;
        this.isUpdating_ = false;
        this.gradeLogPrevTime_ = 0;
        this.data_ = data;
        let self = this;
        this.interval_ = setInterval(function () {
            if (self.isUpdating_) {
                return;
            }
            self.isUpdating_ = true;
            try {
                self.onUpdate();
            }
            catch (error) {
                log_1.Log.oth.error("[match] update failed match id = " + self.data.matchID + " error = ", error);
            }
            self.isUpdating_ = false;
        }, 100);
        this.init();
    }
    get data() {
        return this.data_;
    }
    set data(v) {
        this.data_ = v;
    }
    get matchID() {
        return this.data.matchID;
    }
    get alive() {
        if (this.data_.aliveTimestamp) {
            let time = utils_1.kdutils.getMillionSecond();
            return time < this.data_.aliveTimestamp;
        }
        return true;
    }
    get status() {
        return this.r.status;
    }
    set status(v) {
        log_1.Log.oth.info("[match] match status switch id = " + this.data.matchID + " status = " + MatchDefine_1.MatchDefine.MatchStatus[v]);
        this.r.status = v;
        this.saveRealtime();
    }
    get step() {
        return this.r ? this.r.step : -1;
    }
    set step(v) {
        this.r.step = v;
        this.saveRealtime();
    }
    get r() {
        return this.r_;
    }
    set r(v) {
        this.r_ = v;
    }
    get groupEntity() {
        if (this.data.groupData && this.data.groupData.groupID) {
            return rpc_1.Rpc.groupMgr.getGroupEntitySync(this.data.groupData.groupID);
        }
        return null;
    }
    init() {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[match] start init id = " + this.data.matchID);
            let r = yield this.getRealtime();
            if (r == null) {
                log_1.Log.oth.info("[match] create realtime id = " + this.data.matchID);
                r = {
                    matchID: this.data.matchID,
                    status: MatchDefine_1.MatchDefine.MatchStatus.None,
                    users: [],
                    admins: this.data.admins.slice(),
                    roomIDs: [],
                    step: 0,
                    count: 0,
                    userRecords: []
                };
                yield this.saveRealtime(r);
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.removet", this._getUserRecordTableName());
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.removet", this._getUserScoreBillTableName());
                this.setRankDirty();
            }
            else {
                r.userRecords = [];
                let kvs = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gettAll", this._getUserRecordTableName());
                if (kvs) {
                    log_1.Log.oth.info("[match] read user record length = " + Object.keys(kvs).length);
                    for (let key of Object.keys(kvs)) {
                        let str = kvs[key];
                        let record = JSON.parse(str);
                        r.userRecords.push(record);
                    }
                }
            }
            this.r = r;
            log_1.Log.oth.info("[match] init success id = " + this.data.matchID + " r = ", this.r);
            this.mainLoop();
        });
    }
    getRealtime() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.match.realtime.get", this.data.matchID);
        });
    }
    saveRealtime(r) {
        return __awaiter(this, void 0, void 0, function* () {
            r = r || this.r;
            let records = r.userRecords;
            r.userRecords = null;
            let p = rpc_1.Rpc.center.callException("kds.dbp.match.realtime.update", r);
            r.userRecords = records;
            return yield p;
        });
    }
    _getUserRecordTableName() {
        return "t_match_record_" + this.data.matchID;
    }
    _getUserInfoTableName() {
        return "t_match_userinfo_" + this.data.matchID;
    }
    _getUserScoreBillTableName() {
        return "t_match_score_bill_" + this.data.matchID;
    }
    saveUserRecord(record) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = JSON.stringify(record);
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", this._getUserRecordTableName(), record.userID.toString(), str);
        });
    }
    removeUserRecord(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.delt", this._getUserRecordTableName(), userID.toString());
        });
    }
    getUserRecord(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", this._getUserRecordTableName(), userID.toString());
            if (str) {
                let ret = JSON.parse(str);
                return ret;
            }
            return null;
        });
    }
    saveUserInfo(userInfo) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = JSON.stringify(userInfo);
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", this._getUserInfoTableName(), userInfo.userID.toString(), str);
        });
    }
    getUserInfo(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", this._getUserInfoTableName(), userID.toString());
            if (str) {
                let ret = JSON.parse(str);
                return ret;
            }
            return null;
        });
    }
    saveUserScoreBill(scoreBill) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = JSON.stringify(scoreBill);
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", this._getUserScoreBillTableName(), scoreBill.userID.toString(), str);
        });
    }
    getUserScoreBill(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", this._getUserScoreBillTableName(), userID.toString());
            if (str) {
                let ret = JSON.parse(str);
                return ret;
            }
            return null;
        });
    }
    removeUserScoreBill(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.delt", this._getUserScoreBillTableName(), userID.toString());
        });
    }
    addUserScoreBill(userID, score, bill) {
        return __awaiter(this, void 0, void 0, function* () {
            let item = {
                timestamp: bill.endTimestamp,
                score: score,
                userInfos: [],
            };
            for (let user of bill.users) {
                if (user.chairNo < RoomDefine_1.RoomDefine.watchChairNoStart) {
                    item.userInfos.push({
                        nickName: user.nickName
                    });
                }
            }
            let scoreBill = yield this.getUserScoreBill(userID);
            if (scoreBill == null) {
                scoreBill = {
                    bills: [],
                    userID: userID,
                };
            }
            scoreBill.bills.push(item);
            yield this.saveUserScoreBill(scoreBill);
        });
    }
    createUserRecord(userID) {
        let userRecord = {
            userID: userID,
            score: this.data.defaultScore || 0,
            totalCount: 0,
            win: 0,
            lose: 0,
            draw: 0,
            lastTimestamp: 0,
        };
        return userRecord;
    }
    refreshUserRecord(record) {
        return __awaiter(this, void 0, void 0, function* () {
            let index = this.r.userRecords.findIndex(v => v.userID == record.userID);
            if (index >= 0) {
                this.r.userRecords[index] = record;
            }
            else {
                this.r.userRecords.push(record);
            }
            yield this.saveUserRecord(record);
        });
    }
    isValidUserID(userID) {
        if (this.r.admins.indexOf(userID) >= 0) {
            return true;
        }
        else {
            if (this.r.users.includes(userID)) {
                return true;
            }
            let signMode = this.data.signup & MatchDefine_1.MatchDefine.SignUpMode.FlagMode;
            if (signMode == MatchDefine_1.MatchDefine.SignUpMode.NoSignUp) {
                return true;
            }
        }
        return false;
    }
    userGetRooms(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.isValidUserID(userID)) {
                return [];
            }
            return yield this.doGetRooms();
        });
    }
    adminSignUp(admin, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return "权限不足";
            }
            return yield this.doUserSignUp(userID);
        });
    }
    adminUnSignUp(admin, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return "权限不足";
            }
            return yield this.doUserUnSignUp(userID);
        });
    }
    adminSetUserInfo(admin, userInfo) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return "权限不足";
            }
            return this.doSetUserInfo(userInfo);
        });
    }
    adminGetUserInfo(admin, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return "权限不足";
            }
            if (this.r.users.indexOf(userID) < 0) {
                return "玩家未报名";
            }
            return yield this.getUserInfo(userID);
        });
    }
    adminGetAllUserInfos(admin) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return "权限不足";
            }
            let ret = [];
            for (let userID of this.r.users) {
                let userInfo = yield this.getUserInfo(userID);
                if (userInfo == null) {
                    userInfo = {
                        userID: userID,
                        phoneNumber: "null"
                    };
                }
                ret.push(userInfo);
            }
            return ret;
        });
    }
    adminGetRealtime(admin) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return null;
            }
            return this.r;
        });
    }
    adminGetRooms(admin) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return [];
            }
            return yield this.doGetRooms();
        });
    }
    adminCreateRoom(admin, num, gameData) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return "权限不足";
            }
            return yield this.doCreateRoom(gameData);
        });
    }
    adminJiesanRoom(admin, roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.admins.indexOf(admin) < 0) {
                return "权限不足";
            }
            return yield this.doJiesanRoom(roomID);
        });
    }
    // 玩家报名
    userSignUp(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if ((this.data.signup & MatchDefine_1.MatchDefine.SignUpMode.Self) == 0) {
                return;
            }
            return yield this.doUserSignUp(userID);
        });
    }
    doUserUnSignUp(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r == null) {
                return "请稍后再试";
            }
            if (this.status == MatchDefine_1.MatchDefine.MatchStatus.RoundEnd) {
                return "比赛已经结束";
            }
            let idx = this.r.users.indexOf(userID);
            if (idx < 0) {
                return "玩家不在比赛中";
            }
            this.r.users.splice(idx, 1);
            // 2023/7/24 zhb修改后台管理获取每期参与比赛人数
            this.addUserSignUp();
            idx = this.r.userRecords.findIndex(v => v.userID == userID);
            if (idx >= 0) {
                this.r.userRecords.splice(idx, 1);
                yield this.removeUserRecord(userID);
            }
            yield this.saveRealtime();
            if (this.status > MatchDefine_1.MatchDefine.MatchStatus.Signup) {
                this.setRankDirty();
            }
            return true;
        });
    }
    doUserSignUp(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r == null) {
                return "请稍后再试";
            }
            if (this.status == MatchDefine_1.MatchDefine.MatchStatus.RoundEnd) {
                return "比赛已经结束";
            }
            if ((this.data.signup & MatchDefine_1.MatchDefine.SignUpMode.NoSignUp)) {
                return "当前比赛不需要报名";
            }
            if ((this.data.signup & MatchDefine_1.MatchDefine.SignUpMode.Ex_BeforeStart) && this.status > MatchDefine_1.MatchDefine.MatchStatus.Signup) {
                return "报名已经截止";
            }
            if (this.r.users.indexOf(userID) >= 0) {
                return "不能重复报名";
            }
            if (this.data.maxUserCount > 0 && this.r.users.length >= this.data.maxUserCount) {
                return "参与玩家已达到上限[" + this.data.maxUserCount + "]";
            }
            if (this.data.signupItems && this.data.signupItems.length > 0) {
                let item = this.data.signupItems[0];
                switch (item.itemID) {
                    case ItemDefine_1.ItemID.gold:
                        {
                            if (!(yield rpc_1.Rpc.center.callException("kds.inpay.user.gold", userID, -item.count))) {
                                return "金币数量不足";
                            }
                        }
                        break;
                    case ItemDefine_1.ItemID.diamond:
                        {
                            if (!(yield rpc_1.Rpc.center.callException("kds.inpay.user.diamond", userID, -item.count))) {
                                return "钻石数量不足";
                            }
                        }
                        break;
                }
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.cache.loginData.get", userID);
            if (loginData == null) {
                return "没有找到玩家";
            }
            this.r.users.push(userID);
            // 2023/7/24 zhb修改后台管理获取每期参与比赛人数
            this.addUserSignUp();
            yield this.saveRealtime();
            if (this.status == MatchDefine_1.MatchDefine.MatchStatus.Start) {
                if (this.r.userRecords.find(v => v.userID == userID) == null) {
                    let userRecord = this.createUserRecord(userID);
                    this.refreshUserRecord(userRecord);
                }
            }
            return true;
        });
    }
    // 2023/7/24 zhb修改后台管理获取每期参与比赛人数
    addUserSignUp() {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", 'match_rank:match-count', time, this.r.users.length);
        });
    }
    doSetUserInfo(userInfo) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.users.indexOf(userInfo.userID) < 0) {
                return "玩家未报名";
            }
            yield this.saveUserInfo(userInfo);
            return true;
        });
    }
    doCreateRoom(gameData) {
        return __awaiter(this, void 0, void 0, function* () {
            return "没有实现";
        });
    }
    doJiesanRoom(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            return "没有实现";
        });
    }
    doGetRooms() {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = [];
            let group = this.groupEntity;
            if (group == null) {
                return [];
            }
            let roomIDs = yield group.getAllRoomIDs();
            for (let roomID of roomIDs) {
                let roomRealtime = yield GroupHelper_1.GroupHelper.getRoomRealtime(roomID);
                if (roomRealtime == null) {
                    log_1.Log.oth.error("[match] cannot get room realtime id = " + roomID);
                    continue;
                }
                ret.push(roomRealtime);
            }
            return ret;
        });
    }
    doUserEnterRoom(userID, roomID, watch) {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    userEnter(userID) {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    userExit(userID) {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    userEnterRoom(userID, roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.status == MatchDefine_1.MatchDefine.MatchStatus.RoundEnd) {
                return "比赛已经结束";
            }
            if (this.status != MatchDefine_1.MatchDefine.MatchStatus.Start) {
                return "比赛还没开始";
            }
            let watch = false;
            // 没报名
            if (!this.r.users.includes(userID)) {
                // 需要报名
                let signMode = this.data.signup & MatchDefine_1.MatchDefine.SignUpMode.FlagMode;
                if (signMode != MatchDefine_1.MatchDefine.SignUpMode.NoSignUp) {
                    // 只能旁观
                    watch = true;
                }
            }
            // 管理员只能旁观
            if (this.r.admins.includes(userID)) {
                watch = true;
            }
            let b = yield this.doUserEnterRoom(userID, roomID, watch);
            return b;
        });
    }
    onRoomEnd(roomPOData, roomRealtime, bill) {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    onUserEnterGroup(groupID, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let signMode = this.data.signup & MatchDefine_1.MatchDefine.SignUpMode.FlagMode;
            if (signMode != MatchDefine_1.MatchDefine.SignUpMode.NoSignUp) {
                if (this.r.users.indexOf(userID) < 0) {
                    return "进入失败: 需要报名";
                }
            }
            let userRecord = this.r.userRecords.find(v => v.userID == userID);
            if (userRecord == null) {
                userRecord = this.createUserRecord(userID);
                yield this.refreshUserRecord(userRecord);
            }
            if (this.data.groupGameCount && this.data.groupGameCount >= 0) {
                if (userRecord.totalCount >= this.data.groupGameCount) {
                    log_1.Log.oth.info("[match] user reach max game count userID = " + userID);
                    return "进入失败: 匹配次数已达到最大";
                }
            }
            return true;
        });
    }
    onMatchEnd() {
        return __awaiter(this, void 0, void 0, function* () {
            for (let userID of this.r.users) {
                MatchHelper_1.MatchHelper.clearMatchStatus(userID);
            }
        });
    }
    onRelease() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.interval_) {
                clearInterval(this.interval_);
                log_1.Log.oth.info("[matchBase] onRelease");
                rpc_1.Rpc.groupMgr.removeGroupByMatch(this.data);
                this.interval_ = null;
                for (let userID of this.r.users) {
                    MatchHelper_1.MatchHelper.clearMatchStatus(userID);
                }
                yield rpc_1.Rpc.center.callException("kds.dbp.match.remove", this.matchID);
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.removet", this._getUserRecordTableName());
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.removet", this._getUserScoreBillTableName());
                // await Rpc.center.callException("kds.dbp.kv.c.del",MatchDefine.getMatchRankChangedName(this.data.matchID))
            }
        });
    }
    giveRankReward() {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD", time);
            if (this.data.rankRewards && this.data.rankRewards.length > 0) {
                let maxCount = 0;
                for (let rewardInfo of this.data.rankRewards) {
                    if (rewardInfo.toRank > maxCount) {
                        maxCount = rewardInfo.toRank;
                    }
                }
                let rt = yield rpc_1.Rpc.center.callException("kds.dbp.kv.c.get", MatchDefine_1.MatchDefine.getMatchRankChangedName(this.matchID), KVDefine_1.KVDefine.NULL);
                if (rt == null || rt.data == null) {
                    log_1.Log.oth.error("[match] get rank failed when give rank rewards matchID = " + this.matchID);
                    return false;
                }
                let ranks;
                try {
                    ranks = JSON.parse(rt.data);
                }
                catch (error) {
                    log_1.Log.oth.error("[match] parse rank failed matchID = " + this.matchID);
                    return false;
                }
                let i = 0;
                for (let info of ranks) {
                    i++;
                    let item;
                    for (let tempItem of this.data.rankRewards) {
                        if (i >= tempItem.fromRank && i <= tempItem.toRank) {
                            item = tempItem;
                            break;
                        }
                    }
                    if (item) {
                        log_1.Log.oth.info("[match] give user id = " + info.userID + " rank = " + i + " item = " +
                            ((item.items && item.items.length > 0) ? item.items[0] : null));
                        let userRewardItem = {
                            rewardID: null,
                            items: item.items,
                            timestamp: time,
                            date: date,
                            desc: this.getRankRewardDesc(info.userID, i),
                            matchID: this.matchID,
                            gain: false,
                        };
                        rpc_1.Rpc.matchMgr.addReward(info.userID, userRewardItem);
                    }
                }
                return true;
            }
            return false;
        });
    }
    setRankDirty() {
        this.rankDirty_ = true;
    }
    onRefreshRank(force) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.ranking_) {
                return;
            }
            if (!force && !this.rankDirty_) {
                return;
            }
            if (this.r == null) {
                return;
            }
            this.ranking_ = true;
            try {
                let ranks = [];
                for (let userID of this.r.users) {
                    let t = yield this.getUserRank(userID);
                    if (t) {
                        ranks.push(t);
                    }
                }
                ranks.sort(function (a, b) {
                    if (a.totalCount == 0 && b.totalCount != 0) {
                        return 1;
                    }
                    if (a.totalCount != 0 && b.totalCount == 0) {
                        return -1;
                    }
                    let sub = b.score - a.score;
                    if (sub != 0) {
                        return sub;
                    }
                    let timeA = a.lastTimestamp || 0;
                    let timeB = b.lastTimestamp || 0;
                    if (timeA != timeB) {
                        return timeA - timeB;
                    }
                    return a.userID - b.userID;
                });
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.c.set", MatchDefine_1.MatchDefine.getMatchRankChangedName(this.data.matchID), JSON.stringify(ranks));
                yield this.updateMatchRank(ranks);
            }
            catch (error) {
                log_1.Log.oth.error("[match] refresh rank failed matchID = " + this.data.matchID, error);
            }
            this.ranking_ = false;
            this.rankDirty_ = false;
            this.prevRankTime_ = utils_1.kdutils.getMillionSecond();
        });
    }
    updateMatchRank(ranks) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.data.hasOwnProperty("groupData"))
                return;
            if (this.data.groupData == null || this.data.groupData == undefined)
                return;
            if (!this.data.groupData.hasOwnProperty("createDate"))
                return;
            if (!this.data.groupData.hasOwnProperty("groupID"))
                return;
            let time = this.data.groupData.createDate.split(" ")[0];
            let time2 = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            if (time != time2)
                return;
            let match = yield rpc_1.Rpc.matchMgr.getMatchRank(this.matchID, time);
            // let match = await Rpc.center.callException("kds.dbp.match.getMatchRank", this.matchID, time)
            log_1.Log.oth.info("updateMatchRank match = ", JSON.stringify(match));
            if (!match || match.length < 1) {
                log_1.Log.oth.info("updateMatchRank match set = ", JSON.stringify(match));
                let matchName = time + this.data.name;
                let obj = {
                    ranks: ranks.slice(0, 200),
                    matchID: this.matchID,
                    groupID: this.data.groupData.groupID,
                    createDate: this.data.groupData.createDate,
                    endDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss"),
                    isGrant: false,
                    desc: matchName,
                    rankRewards: this.data.rankRewards,
                    rewardName: this.data.name + (this.r.count + 1) + "期",
                    rewardTime: time,
                };
                // let db = DB.get('kds-match', "match")
                // await db.insert('t_match_rank', obj)
                yield rpc_1.Rpc.center.callException("kds.dbp.match.addMatchRank", obj);
            }
            else {
                log_1.Log.oth.info("updateMatchRank match update = ", JSON.stringify(ranks));
                let data = match[0];
                data.ranks = ranks.slice(0, 200);
                data.endDate = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
                // let db = DB.get('kds-match', "match")
                // let kv = {
                // 	"createDate": { '$regex': this.data.groupData.createDate },
                // 	"matchID": this.matchID
                // }
                // await db.update('t_match_rank', kv, data)
                yield rpc_1.Rpc.center.callException("kds.dbp.match.updateMatchRank", this.matchID, this.data.groupData.createDate, data);
            }
        });
    }
    getUserRank(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.r.users.indexOf(userID) < 0) {
                return null;
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            if (loginData == null) {
                log_1.Log.oth.error("[match] getUserRank: cannot get user login data userID = " + userID);
                return null;
            }
            let record = this.r.userRecords.find(v => v.userID == userID);
            if (record == null || record.totalCount == 0) {
                return null;
            }
            let ret = {
                userID: userID,
                nickName: loginData.nickName,
                iconUrl: loginData.iconUrl,
                sex: loginData.sex,
                win: record ? record.win : 0,
                lose: record ? record.lose : 0,
                draw: record ? record.draw : 0,
                totalCount: record ? record.totalCount : 0,
                score: record ? record.score : 0,
                lastTimestamp: record ? record.lastTimestamp : 0,
            };
            return ret;
        });
    }
    onUpdate() {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            if (this.data.rankInterval != null) {
                if (this.prevRankTime_ <= 0 || time - this.prevRankTime_ >= this.data.rankInterval) {
                    this.onRefreshRank();
                }
            }
        });
    }
    getTimeout(from, to) {
        let sub = Math.abs(to - from);
        if (sub > 10000) {
            return 10000;
        }
        if (sub > 5000) {
            return 1000;
        }
        return 500;
    }
    /**
     *
     * @param userID
     * @param rankIdx 从1开始
     */
    getRankRewardDesc(userID, rankIdx) {
        return this.data.name ? this.data.name : ("比赛" + this.matchID);
    }
    createGroupMates(users) {
        let ret = null;
        let curTime = utils_1.kdutils.getMillionSecond();
        let gameSet = this.groupEntity.gameSet;
        switch (this.data.groupType) {
            case MatchDefine_1.MatchDefine.MatchGroupType.ModeGrade:
                {
                    ret = [];
                    if (users.length < gameSet.getUserCount()) {
                        break;
                    }
                    let logEnabled = false;
                    if (curTime - this.gradeLogPrevTime_ >= 10000) {
                        logEnabled = true;
                        this.gradeLogPrevTime_ = curTime;
                    }
                    let gradeData = MatchExtensions_1.MatchExtensions.parseModeGradeData(this.data.groupExtData);
                    if (gradeData == null) {
                        break;
                    }
                    if (logEnabled) {
                        log_1.Log.oth.info("[match] parse grade data = ", gradeData);
                    }
                    gradeData.grades.sort((a, b) => a.min - b.min);
                    gradeData.steps.sort((a, b) => a.timeout - b.timeout);
                    let userGradeDatas = [];
                    for (let userID of users) {
                        let record = this.r.userRecords.find(v => v.userID == userID);
                        let score = 0;
                        let grade = 0;
                        let stepOffset = 0;
                        if (record) {
                            score = record.score;
                        }
                        if (gradeData.grades.length > 0) {
                            let minInfo = gradeData.grades[0];
                            let maxInfo = gradeData.grades[gradeData.grades.length - 1];
                            if (score < minInfo.min) {
                                grade = minInfo.num;
                            }
                            else if (score > maxInfo.max) {
                                grade = maxInfo.num;
                            }
                            else {
                                for (let info of gradeData.grades) {
                                    if (score >= info.min && score <= info.max) {
                                        grade = info.num;
                                        break;
                                    }
                                }
                            }
                        }
                        let time = this.groupEntity.getUserEnterTime(userID);
                        if (time) {
                            let sub = curTime - time;
                            for (let info of gradeData.steps) {
                                if (sub > info.timeout) {
                                    stepOffset = info.offset;
                                }
                            }
                        }
                        userGradeDatas.push({
                            userID: userID,
                            score: score,
                            grade: grade,
                            stepOffset: stepOffset,
                        });
                    }
                    if (logEnabled) {
                        log_1.Log.oth.info("[match] start create group mates userIDs = ", users);
                        log_1.Log.oth.info(userGradeDatas);
                    }
                    userGradeDatas.sort((a, b) => b.grade - a.grade);
                    let userCount = gameSet.getUserCount();
                    for (let si = 0; si < userGradeDatas.length - (userCount - 1); si++) {
                        let userIDs = [];
                        for (let i = 0; i < userCount; i++) {
                            let idx = si + i;
                            userIDs.push(userGradeDatas[idx].userID);
                        }
                        let valid = true;
                        for (let i = 0; i < userCount; i++) {
                            let selfIndex = i;
                            let selfUserID = userIDs[i];
                            let selfData = userGradeDatas.find(v => v.userID == selfUserID);
                            let selfMin = selfData.grade - selfData.stepOffset;
                            let selfMax = selfData.grade + selfData.stepOffset;
                            for (let j = selfIndex + 1; j < userCount; j++) {
                                let userID = userIDs[j];
                                let data = userGradeDatas.find(v => v.userID == userID);
                                let min = data.grade - data.stepOffset;
                                let max = data.grade + data.stepOffset;
                                if (min > selfMax || selfMin > max) {
                                    valid = false;
                                    break;
                                }
                            }
                            if (!valid) {
                                break;
                            }
                        }
                        if (valid) {
                            ret.push(userIDs);
                            log_1.Log.oth.info("[match] create mates = ", userIDs);
                            break;
                        }
                    }
                }
                break;
        }
        return ret;
    }
    loop_MatchInit() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    loop_WaitForSignup() {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (this.data.signupStartTimestamp) != "number") {
                return;
            }
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                if (time >= this.data.signupStartTimestamp) {
                    break;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, this.data.signupStartTimestamp));
            }
        });
    }
    loop_SignUp() {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (this.data.signupEndTimestamp) != "number") {
                return;
            }
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                if (time >= this.data.signupEndTimestamp) {
                    break;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, this.data.signupEndTimestamp));
            }
        });
    }
    loop_WaitForStart() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!utils_1.kdutils.isArray(this.data.startTimes)) {
                return;
            }
            let times = this.data.startTimes[this.step];
            if (times == null) {
                return;
            }
            let startTimestamp = times.startTimestamp;
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                if (time >= startTimestamp) {
                    break;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, startTimestamp));
            }
            log_1.Log.oth.info("[match] ready to start ,prepare users");
            let realUsers = [];
            //this.r.userRecords = []
            for (let userID of this.r.users) {
                let b = yield MatchHelper_1.MatchHelper.setupMatchStatus(userID, this.data);
                if (!b) {
                    log_1.Log.oth.info("[match] user preparse failed userID = " + userID);
                    continue;
                }
                else {
                    log_1.Log.oth.info("[match] user prepare success");
                }
                realUsers.push(userID);
                let userRecord = this.r.userRecords.find(v => v.userID == userID);
                if (userRecord == null) {
                    log_1.Log.oth.info("[match] create new user record");
                    userRecord = this.createUserRecord(userID);
                }
                this.refreshUserRecord(userRecord);
            }
            this.r.users = realUsers;
            yield this.saveRealtime();
        });
    }
    loop_MatchStart() {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[match] match start not implement id = " + this.data.matchID);
        });
    }
    loop_NextStep() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    loop_WaitForRestart() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    loop_MatchRestart() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    checkEnd() {
        return this.status == MatchDefine_1.MatchDefine.MatchStatus.RoundEnd;
    }
    doMatchEnd() {
        this.status = MatchDefine_1.MatchDefine.MatchStatus.RoundEnd;
    }
    mainLoop() {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[match] main loop start id = " + this.data.matchID);
            yield this.loop_MatchInit();
            //this.r.count = 0
            while (true) {
                //this.step = 0
                //if(this.status == MatchDefine.MatchStatus.None) {
                log_1.Log.oth.info("[match] id = " + this.data.matchID + " loop_WaitForSignup");
                yield this.loop_WaitForSignup();
                this.status = MatchDefine_1.MatchDefine.MatchStatus.Signup;
                //}
                //if(this.status == MatchDefine.MatchStatus.Signup) {
                log_1.Log.oth.info("[match] id = " + this.data.matchID + " loop_SignUp");
                yield this.loop_SignUp();
                this.status = MatchDefine_1.MatchDefine.MatchStatus.Wait;
                //}
                // 多轮次比赛的控制
                while (true) {
                    if (this.status == MatchDefine_1.MatchDefine.MatchStatus.Wait) {
                        log_1.Log.oth.info("[match] id = " + this.data.matchID + " loop_WaitForStart");
                        yield this.loop_WaitForStart();
                        this.status = MatchDefine_1.MatchDefine.MatchStatus.Start;
                    }
                    if (this.status == MatchDefine_1.MatchDefine.MatchStatus.Start) {
                        log_1.Log.oth.info("[match] id = " + this.data.matchID + " loop_MatchStart");
                        yield this.loop_MatchStart();
                    }
                    if (this.checkEnd()) {
                        break;
                    }
                    let b = yield this.loop_NextStep();
                    log_1.Log.oth.info("[match] id = " + this.data.matchID + " loop_NextStep " + b);
                    if (!b) {
                        break;
                    }
                    this.step++;
                    this.status = MatchDefine_1.MatchDefine.MatchStatus.Wait;
                }
                if (this.checkEnd()) {
                    break;
                }
                this.status = MatchDefine_1.MatchDefine.MatchStatus.End;
                // 循环赛的控制
                log_1.Log.oth.info("[match] id = " + this.data.matchID + " loop_WaitForRestart");
                yield this.loop_WaitForRestart();
                if (this.checkEnd()) {
                    break;
                }
                let b = yield this.loop_MatchRestart();
                log_1.Log.oth.info("[match] id = " + this.data.matchID + " loop_MatchRestart " + b);
                if (!b) {
                    break;
                }
                this.r.count++;
                this.status = MatchDefine_1.MatchDefine.MatchStatus.RoundEnd;
                //this.saveRealtime()
            }
        });
    }
}
exports.MatchBase = MatchBase;
