"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchHelper = void 0;
const UserFlag_1 = require("../../../kds-base-define/src/UserFlag");
const GroupHelper_1 = require("../group/GroupHelper");
const log_1 = require("../log");
const rpc_1 = require("../rpc");
var MatchHelper;
(function (MatchHelper) {
    function setupMatchStatus(userID, matchData) {
        return __awaiter(this, void 0, void 0, function* () {
            let matchID = matchData.matchID;
            let matchGroupType = matchData.groupType;
            let roomID = yield GroupHelper_1.GroupHelper.getUserFlag(userID, UserFlag_1.UserFlag.RoomID);
            if (roomID) {
                log_1.Log.oth.info("[match] user setup match failed userID = " + userID + " matchID = " + matchID + " roomID = " + roomID);
                return false;
            }
            let groupID = rpc_1.Rpc.groupMgr.getUserGroupID(userID);
            if (groupID) {
                if (!(yield rpc_1.Rpc.groupMgr.userExit(userID))) {
                    log_1.Log.oth.info("[match] user setup match failed userID = " + userID + " matchID = " + matchID + " groupID = " + groupID);
                    return false;
                }
            }
            yield GroupHelper_1.GroupHelper.setUserFlag(userID, UserFlag_1.UserFlag.MatchID, matchID);
            yield GroupHelper_1.GroupHelper.setUserFlag(userID, UserFlag_1.UserFlag.MatchGroupType, matchGroupType);
            return true;
        });
    }
    MatchHelper.setupMatchStatus = setupMatchStatus;
    function clearMatchStatus(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield GroupHelper_1.GroupHelper.removeUserFlag(userID, UserFlag_1.UserFlag.MatchID);
            yield GroupHelper_1.GroupHelper.removeUserFlag(userID, UserFlag_1.UserFlag.MatchGroupType);
        });
    }
    MatchHelper.clearMatchStatus = clearMatchStatus;
})(MatchHelper = exports.MatchHelper || (exports.MatchHelper = {}));
