"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchManager = void 0;
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const async_1 = require("kdweb-core/lib/tools/async");
const ItemDefine_1 = require("../../../kds-base-define/src/ItemDefine");
let userRewardTableName = "t_match_user_reward";
class MatchManager {
    constructor() {
        this.init_ = false;
        this.entities_ = [];
        this.clazz_ = new Map();
        this.userRewardMutex_ = new Map();
        this.init();
    }
    init() {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[match-mgr] wait for init 2 sec");
            yield async_1.kdasync.timeout(2000);
            log_1.Log.oth.info("[match-mgr] init");
            let matchDatas = yield rpc_1.Rpc.center.callException("kds.dbp.match.getAll");
            log_1.Log.oth.info("[match-mgr] get matches = ", matchDatas);
            if (matchDatas && matchDatas.length > 0) {
                for (let data of matchDatas) {
                    let entity = this.createEntityByMode(data);
                    if (entity == null) {
                        log_1.Log.oth.error("[match-mgr] create entity failed matchID = " + data.matchID);
                    }
                    else {
                        log_1.Log.oth.info("[match-mgr] create entity success matchID = " + data.matchID);
                        this.entities_.push(entity);
                    }
                }
            }
            this.init_ = true;
        });
    }
    addMatch(data) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.init_) {
                log_1.Log.oth.error("[match-mgr] init not finished");
                return false;
            }
            let curData = yield rpc_1.Rpc.center.callException("kds.dbp.match.get", data.matchID);
            if (curData != null) {
                log_1.Log.oth.error("[match-mgr] cannot add match, match id exist data = ", data);
                return false;
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.match.add", data);
            let entity = this.createEntityByMode(data);
            if (entity == null) {
                log_1.Log.oth.error("[match-mgr] create entity failed matchID = " + data.matchID);
                return false;
            }
            else {
                log_1.Log.oth.info("[match-mgr] create entity success matchID = " + data.matchID);
                this.entities_.push(entity);
            }
            return true;
        });
    }
    // 2023/5/25 zhb增加后台管理获取比赛列表
    getAllMatch() {
        return __awaiter(this, void 0, void 0, function* () {
            // if(!this.init_) {
            // 	Log.oth.error("[match-mgr] init not finished")
            // 	return false 
            // }
            let matchDatas = yield rpc_1.Rpc.center.callException("kds.dbp.match.getAll");
            // this.entities_ = [];
            // if (matchDatas && matchDatas.length > 0) {
            // 	for (let data of matchDatas) {
            // 		let entity = this.createEntityByMode(data)
            // 		if (entity == null) {
            // 			Log.oth.error("[match-mgr] create entity failed matchID = " + data.matchID)
            // 		} else {
            // 			Log.oth.info("[match-mgr] create entity success matchID = " + data.matchID)
            // 			this.entities_.push(entity)
            // 		}
            // 	}
            // }
            if (matchDatas && matchDatas.length > 0) {
                for (let i = 0; i < matchDatas.length; i++) {
                    matchDatas['rid'] = i + 1;
                }
                return matchDatas;
            }
            return [];
        });
    }
    updateMatch(matchID, data) {
        return __awaiter(this, void 0, void 0, function* () {
            // if(!this.init_) {
            // 	Log.oth.error("[match-mgr] init not finished")
            // 	return false 
            // }
            let matchDatas = yield rpc_1.Rpc.center.callException("kds.dbp.match.getAll");
            if (matchDatas && matchDatas.length > 0) {
                for (let data of matchDatas) {
                    if (data.matchID === matchID) {
                        let matchDatas = yield rpc_1.Rpc.center.callException("kds.dbp.match.update", data);
                        return matchDatas;
                    }
                }
            }
            return false;
        });
    }
    removeMatch(matchID) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.init_) {
                log_1.Log.oth.error("[match-mgr] init not finished");
                return false;
            }
            let index = this.entities_.findIndex(v => v.data.matchID == matchID);
            if (index < 0) {
                return true;
            }
            let entity = this.entities_[index];
            entity.onRelease();
            this.entities_.splice(index, 1);
            return true;
        });
    }
    get entities() {
        return this.entities_.slice(0);
    }
    getMatchEntity(matchID) {
        let ret = this.entities_.find(v => v.data.matchID == matchID);
        return ret;
    }
    regModeClass(mode, v) {
        this.clazz_.set(mode, v);
    }
    createEntityByMode(matchData) {
        let clazz = this.clazz_.get(matchData.mode);
        if (clazz) {
            return new clazz(matchData);
        }
        return null;
    }
    addReward(userID, reward) {
        return __awaiter(this, void 0, void 0, function* () {
            let wait = this.userRewardMutex_.get(userID);
            if (wait) {
                yield wait.promise;
            }
            wait = new async_1.kdasync.wait();
            this.userRewardMutex_.set(userID, wait);
            let data = yield this.getRewards(userID);
            let id = yield rpc_1.Rpc.center.callException("kds.ids.getId", "match-reward-id", 100000, 1);
            if (id == null) {
                id = -1;
            }
            reward.rewardID = id;
            data.rewards.push(reward);
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", userRewardTableName, userID.toString(), JSON.stringify(data));
            this.userRewardMutex_.delete(userID);
            wait.resolve();
        });
    }
    getRewards(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", userRewardTableName, userID.toString());
            let data;
            if (str == null) {
                data = {
                    rewards: []
                };
            }
            else {
                data = JSON.parse(str);
            }
            return data;
        });
    }
    // 2023/7/26 zhb修改后台管理获取根据用户id、比赛id、比赛时间、查询比赛对局详情
    getMatchInfo(time, matchID, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            // let db = DB.get('kds-match', 'match')
            let kv = {
                "createDate": { '$regex': time },
                "matchID": matchID,
                "userScores.userID": userID
            };
            let msg = {
                sort: {
                    createDate: 1
                }
            };
            // let data = await db.getOption('t_match_record', kv, {
            // 	sort: {
            // 		createDate: 1
            // 	}
            // })
            let data = yield rpc_1.Rpc.center.callException('kds.dbp.match.getMatchRecord', kv, msg);
            return data;
        });
    }
    // 2023/7/26 zhb修改后台管理按日期获取比赛排行榜
    getMatchRank(matchID, createDate) {
        return __awaiter(this, void 0, void 0, function* () {
            // let db = DB.get('kds-match', 'match')
            // let kv = {
            // 	"createDate": { '$regex': createDate },
            // 	"matchID": matchID
            // }
            // let data = await db.getOption('t_match_rank', kv)
            let msg = yield rpc_1.Rpc.center.call("kds.dbp.match.getMatchRank", matchID, createDate);
            log_1.Log.oth.info("getMatchRank callback :", msg);
            if (msg.code != 0) {
                return false;
            }
            return msg.data;
        });
    }
    // 2023/7/26 zhb修改后台管理更新排行榜数据
    updateMatchRank(matchID, createDate, matchData) {
        return __awaiter(this, void 0, void 0, function* () {
            // let kv = {
            // 	"createDate": { '$regex': createDate },
            // 	"matchID": matchID
            // }
            // let data = await db.update('t_match_rank', kv, matchData)
            let data = yield rpc_1.Rpc.center.callException("kds.dbp.match.updateMatchRank", matchID, createDate, matchData);
            return data;
        });
    }
    gainRewards(userID, rewardID) {
        return __awaiter(this, void 0, void 0, function* () {
            let wait = this.userRewardMutex_.get(userID);
            if (wait) {
                yield wait.promise;
            }
            wait = new async_1.kdasync.wait();
            this.userRewardMutex_.set(userID, wait);
            let ret = false;
            let data = yield this.getRewards(userID);
            let reward = data.rewards.find(v => v.rewardID == rewardID && v.gain == false);
            if (reward) {
                for (let item of reward.items) {
                    switch (item.itemID) {
                        case ItemDefine_1.ItemID.gold:
                            {
                                yield rpc_1.Rpc.center.callException("kds.inpay.user.gold", userID, item.count);
                                ret = true;
                            }
                            break;
                        case ItemDefine_1.ItemID.diamond:
                            {
                                yield rpc_1.Rpc.center.callException("kds.inpay.user.diamond", userID, item.count);
                                ret = true;
                            }
                            break;
                        default:
                            {
                                // 不能领取的由前端控制，保留功能
                                ret = true;
                            }
                            break;
                    }
                }
                if (ret) {
                    reward.gain = true;
                    yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", userRewardTableName, userID.toString(), JSON.stringify(data));
                }
            }
            this.userRewardMutex_.delete(userID);
            wait.resolve();
            return ret;
        });
    }
    // 2023/7/25 zhb修改后台管理增加删除玩家奖励
    delRewards(userID, rewardID) {
        return __awaiter(this, void 0, void 0, function* () {
            let wait = this.userRewardMutex_.get(userID);
            if (wait) {
                yield wait.promise;
            }
            wait = new async_1.kdasync.wait();
            this.userRewardMutex_.set(userID, wait);
            let ret = false;
            let data = yield this.getRewards(userID);
            const index = data.rewards.findIndex(reward => reward.rewardID === rewardID);
            if (index !== -1) {
                data.rewards.splice(index, 1);
                yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", userRewardTableName, userID.toString(), JSON.stringify(data));
                ret = true;
            }
            this.userRewardMutex_.delete(userID);
            wait.resolve();
            return ret;
        });
    }
    // 2023/7/26 zhb修改后台管理查询用户是否在黑名单
    getUserOfInBlackList(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            // let db = DB.get('kds-match', 'match')
            // let user = await db.getSingle('t_match_blacklist', { 'userID': userID })
            return yield rpc_1.Rpc.center.callException("kds.dbp.match.updateMatchRank", userID);
        });
    }
}
exports.MatchManager = MatchManager;
