"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchEx_Circle = void 0;
const async_1 = require("kdweb-core/lib/tools/async");
const utils_1 = require("kdweb-core/lib/utils");
const KVDefine_1 = require("../../../../kds-base-define/src/KVDefine");
const MatchDefine_1 = require("../../../../kds-base-define/src/MatchDefine");
const log_1 = require("../../log");
const rpc_1 = require("../../rpc");
const MatchBase_1 = require("../MatchBase");
const MatchHelper_1 = require("../MatchHelper");
/**
 * 循环赛
 * 报名和比赛的时间都是以当天时间为基准的，即当天0点起始的时间戳为0
 */
let circle = MatchDefine_1.MatchDefine.CircleTimeIndex;
let changedRank = new Map();
class MatchEx_Circle extends MatchBase_1.MatchBase {
    checkTimesValid() {
        let times = this.data.startTimes;
        if (!utils_1.kdutils.isArray(times)) {
            return false;
        }
        for (let i = 0; i < circle.IndexEnd; i++) {
            let timeInfo = times[i];
            if (timeInfo == null) {
                return false;
            }
        }
        return true;
    }
    loop_WaitForSignup() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.checkTimesValid()) {
                log_1.Log.oth.error("[circle:loop_WaitForSignup] time invalid ");
                return;
            }
            let times = this.data.startTimes;
            let validTime = times[circle.Valid].startTimestamp;
            let intervalTime = times[circle.Interval].startTimestamp;
            let stdLoopStartTimes = times[circle.STD_LoopStart];
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                let offset = this.r.count * intervalTime + validTime;
                if (time >= validTime) {
                    let loopStartTime = offset + stdLoopStartTimes.startTimestamp;
                    // 服务器重启后如果比赛是结束状态，需要这里特殊处理一下
                    if (time < loopStartTime) {
                        // if(this.status != MatchDefine.MatchStatus.Wait) {
                        // 	this.status = MatchDefine.MatchStatus.Wait
                        // }
                        yield async_1.kdasync.timeout(this.getTimeout(time, loopStartTime));
                        continue;
                    }
                    let stdSignTimes = times[circle.STD_Sign];
                    let signStartTime = offset + stdSignTimes.startTimestamp;
                    let signEndTime = offset + stdSignTimes.endTimestamp;
                    if (time >= signStartTime) {
                        return;
                    }
                    yield async_1.kdasync.timeout(this.getTimeout(time, signStartTime));
                    continue;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, validTime));
            }
        });
    }
    loop_SignUp() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.checkTimesValid()) {
                log_1.Log.oth.error("[circle:loop_SignUp] time invalid ");
                return;
            }
            let times = this.data.startTimes;
            let validTime = times[circle.Valid].startTimestamp;
            let intervalTime = times[circle.Interval].startTimestamp;
            let stdSignTimes = times[circle.STD_Sign];
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                let offset = this.r.count * intervalTime + validTime;
                let signEndTime = offset + stdSignTimes.endTimestamp;
                if (time >= signEndTime) {
                    return;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, signEndTime));
            }
        });
    }
    loop_WaitForStart() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.checkTimesValid()) {
                log_1.Log.oth.error("[circle:loop_WaitForStart] time invalid ");
                return;
            }
            let times = this.data.startTimes;
            let validTime = times[circle.Valid].startTimestamp;
            let intervalTime = times[circle.Interval].startTimestamp;
            let stdMatchTimes = times[circle.STD_Match];
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                let offset = this.r.count * intervalTime + validTime;
                let matchStartTime = offset + stdMatchTimes.startTimestamp;
                if (time >= matchStartTime) {
                    break;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, matchStartTime));
            }
            log_1.Log.oth.info("[circle:match] ready to start ,prepare users");
            let realUsers = [];
            //this.r.userRecords = []
            for (let userID of this.r.users) {
                let b = yield MatchHelper_1.MatchHelper.setupMatchStatus(userID, this.data);
                if (!b) {
                    log_1.Log.oth.info("[circle:match] user preparse failed userID = " + userID);
                    continue;
                }
                else {
                    log_1.Log.oth.info("[circle:match] user prepare success");
                }
                realUsers.push(userID);
                let userRecord = this.r.userRecords.find(v => v.userID == userID);
                if (userRecord == null) {
                    log_1.Log.oth.info("[circle:match] create new user record");
                    userRecord = this.createUserRecord(userID);
                }
                this.refreshUserRecord(userRecord);
            }
            this.r.users = realUsers;
            yield this.saveRealtime();
        });
    }
    loop_MatchStart() {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[circle:match-free] match start");
            if (!this.checkTimesValid()) {
                log_1.Log.oth.error("[circle:loop_MatchStart] time invalid ");
                this.doMatchEnd();
                return;
            }
            let times = this.data.startTimes;
            let validTime = times[circle.Valid].startTimestamp;
            let intervalTime = times[circle.Interval].startTimestamp;
            let stdMatchTimes = times[circle.STD_Match];
            let offset = this.r.count * intervalTime + validTime;
            let matchEndTime = offset + stdMatchTimes.endTimestamp;
            let time = utils_1.kdutils.getMillionSecond();
            if (time >= matchEndTime) {
                return;
            }
            let b = rpc_1.Rpc.groupMgr.addGroupByMatch(this.data);
            if (!b) {
                log_1.Log.oth.error("[circle:match-free] cannot create group entity match id = " + this.matchID);
                this.doMatchEnd();
                return;
            }
            let c = yield rpc_1.Rpc.center.callException("kds.dbp.group.add", this.data.groupData);
            if (!c) {
                log_1.Log.oth.error("[circle:match-free] kds.dbp.group.add = ", JSON.stringify(c));
                this.doMatchEnd();
                return;
            }
            log_1.Log.oth.info("[circle:match-free] match start groupID = " + this.data.groupData.groupID + " | matchID = " + this.matchID);
            log_1.Log.oth.info("[circle:match-free] match start matchEndTime = ", matchEndTime);
            log_1.Log.oth.info("[circle:match-free] match start count = ", this.r.count, " intervalTime = ", intervalTime + " validTime = " + validTime);
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                if (time >= matchEndTime) {
                    break;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, matchEndTime));
            }
            yield this.setMatchRankData();
            log_1.Log.oth.info("[circle:match-free] match end groupID = " + this.data.groupData.groupID + " | matchID = " + this.matchID);
            log_1.Log.oth.info("[circle:match-free] match end matchEndTime = ", matchEndTime);
            log_1.Log.oth.info("[circle:match-free] match end count = ", this.r.count, " intervalTime = ", intervalTime + " validTime = " + validTime);
            rpc_1.Rpc.groupMgr.removeGroupByMatch(this.data);
        });
    }
    setMatchRankData() {
        return __awaiter(this, void 0, void 0, function* () {
            let time = this.data.groupData.createDate.split(" ")[0];
            let match = yield rpc_1.Rpc.matchMgr.getMatchRank(this.matchID, time);
            if (match && match.length > 0) {
                return;
            }
            let ranks = yield this.getMatchRank(this.matchID, {
                limitCount: 200
            });
            let matchName = time + this.data.name;
            let obj = {
                ranks: ranks,
                matchID: this.matchID,
                groupID: this.data.groupData.groupID,
                createDate: this.data.groupData.createDate,
                endDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss"),
                isGrant: false,
                desc: matchName,
                rankRewards: this.data.rankRewards,
                rewardName: this.data.name + (this.r.count + 1) + "期",
                rewardTime: time,
            };
            // let db = DB.get('kds-match', "match")
            // await db.insert('t_match_rank', obj)
            yield rpc_1.Rpc.center.callException("kds.dbp.match.addMatchRank", obj);
        });
    }
    getMatchRank(matchID, opt) {
        return __awaiter(this, void 0, void 0, function* () {
            opt = opt || {};
            let userInfos = yield async_1.kdasync.queueFunc(this._getRank)(matchID);
            if (userInfos == null) {
                return [];
            }
            let selfUserInfo = null;
            if (opt.limitCount != null) {
                userInfos = userInfos.slice(0, opt.limitCount);
            }
            if (selfUserInfo) {
                userInfos.splice(0, 0, selfUserInfo);
            }
            return userInfos;
        });
    }
    _getRank(matchID) {
        return __awaiter(this, void 0, void 0, function* () {
            let t = changedRank.get(matchID);
            log_1.Log.oth.info("_getRank t = ", t ? JSON.stringify(t) : 'null');
            let rt = yield rpc_1.Rpc.center.callException("kds.dbp.kv.c.get", MatchDefine_1.MatchDefine.getMatchRankChangedName(matchID), t ? t.tag : KVDefine_1.KVDefine.NULL);
            log_1.Log.oth.info("_getRank rt = ", JSON.stringify(rt));
            let str = null;
            if (rt == null) {
                str = t ? t.data : null;
            }
            else {
                if (rt.changed == false) {
                    str = t ? t.data : null;
                }
                else {
                    str = rt.data;
                    changedRank.set(matchID, rt);
                }
            }
            if (str == null) {
                log_1.Log.oth.error("[match] get match rank failed id = " + matchID, rt);
                return null;
            }
            let userInfos = JSON.parse(str);
            return userInfos;
        });
    }
    loop_NextStep() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    loop_WaitForRestart() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.checkTimesValid()) {
                log_1.Log.oth.error("[circle:loop_WaitForRestart] time invalid ");
                return;
            }
            let times = this.data.startTimes;
            let validTime = times[circle.Valid].startTimestamp;
            let intervalTime = times[circle.Interval].startTimestamp;
            let stdLoopStartTimes = times[circle.STD_LoopStart];
            let offset = (this.r.count + 1) * intervalTime + validTime;
            let loopStartTime = offset + stdLoopStartTimes.startTimestamp;
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                if (time >= loopStartTime) {
                    return;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, loopStartTime));
            }
        });
    }
    loop_MatchRestart() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.checkTimesValid()) {
                log_1.Log.oth.error("[circle:loop_MatchRestart] time invalid ");
                return false;
            }
            // await this.giveRankReward()
            this.r.users = [];
            this.r.userRecords = [];
            yield this.saveRealtime();
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.removet", this._getUserRecordTableName());
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.removet", this._getUserScoreBillTableName());
            yield this.onRefreshRank(true);
            return true;
        });
    }
}
exports.MatchEx_Circle = MatchEx_Circle;
