"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchEx_CustomRoom = void 0;
const async_1 = require("kdweb-core/lib/tools/async");
const utils_1 = require("kdweb-core/lib/utils");
const log_1 = require("../../log");
const rpc_1 = require("../../rpc");
const MatchBase_1 = require("../MatchBase");
const RoomDefine_1 = require("../../../../kds-base-define/src/RoomDefine");
const GroupHelper_1 = require("../../group/GroupHelper");
const SrsDefine_1 = require("../../../../kds-base-define/src/SrsDefine");
const GameSet_1 = require("../../../../kds-base-define/src/GameSet");
// 建房间
class MatchEx_CustomRoom extends MatchBase_1.MatchBase {
    // async userSignUp(userID:number) {
    // 	return "该比赛不能自己报名"
    // }
    loop_MatchStart() {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[match-custom] match start");
            if (!utils_1.kdutils.isArray(this.data.startTimes)) {
                log_1.Log.oth.error("[match-custom] match start failed time is null match id = " + this.matchID);
                this.doMatchEnd();
                return;
            }
            let times = this.data.startTimes[this.step];
            if (times == null) {
                return;
            }
            let time = utils_1.kdutils.getMillionSecond();
            let endTimestamp = times.endTimestamp;
            if (time >= endTimestamp) {
                return;
            }
            log_1.Log.oth.info("[match-custom] match start matchID = " + this.matchID);
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                if (time >= endTimestamp) {
                    break;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, endTimestamp));
            }
            log_1.Log.oth.info("[match-custom] match end matchID = " + this.matchID);
        });
    }
    loop_NextStep() {
        return __awaiter(this, void 0, void 0, function* () {
            return (this.step + 1) <= (this.data.startTimes.length - 1);
        });
    }
    onRoomEnd(roomPOData, roomRealtime, bill) {
        const _super = Object.create(null, {
            onRoomEnd: { get: () => super.onRoomEnd }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.onRoomEnd.call(this, roomPOData, roomRealtime, bill);
            yield this.removeRoomID(roomPOData.roomData.roomID);
            if (bill == null) {
                return;
            }
            log_1.Log.oth.info("[match-custom] onRoomEnd roomID = " + roomPOData.roomID);
            let runtime = bill.runtime;
            let userScores = [];
            let roomData = roomPOData.roomData;
            let gameData = roomData.gameData;
            let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
            for (let i = 0; i < gameSet.getUserCount(); i++) {
                let user = bill.users.find(v => v.chairNo == i);
                userScores.push({
                    userID: user.userID,
                    score: 0
                });
            }
            if (runtime.roundEndType == "Jiesan") {
            }
            else if (runtime.roundEndType == "Escape") {
                let scores = bill.scores.slice(0);
                scores.sort((a, b) => a.score - b.score);
                let loser = scores[0];
                log_1.Log.oth.info(scores);
                log_1.Log.oth.info(loser);
                for (let chairNo = 0; chairNo < userScores.length; chairNo++) {
                    let userScore = userScores[chairNo];
                    if (chairNo == loser.chairNo) {
                        userScore.score -= 3 * gameSet.getScore();
                    }
                    else {
                        if (Math.abs(chairNo - loser.chairNo) == 2) {
                            userScore.score = 0;
                        }
                        else {
                            userScore.score += gameSet.getScore();
                        }
                    }
                }
            }
            else if (runtime.roundEndType == "Normal") {
                for (let chairNo = 0; chairNo < userScores.length; chairNo++) {
                    let userScore = userScores[chairNo];
                    let scoreInfo = bill.scores.find(v => v.chairNo == chairNo);
                    if (scoreInfo.score > 0) {
                        userScore.score += gameSet.getScore();
                    }
                    else {
                        userScore.score -= gameSet.getScore();
                    }
                }
            }
            let time = utils_1.kdutils.getMillionSecond();
            log_1.Log.oth.info("[match-custom] calc result userScores =  ", userScores);
            for (let userScore of userScores) {
                let user = this.r.userRecords.find(v => v.userID == userScore.userID);
                user.score += userScore.score;
                if (userScore.score > 0) {
                    user.win++;
                }
                else if (userScore.score < 0) {
                    user.lose++;
                }
                else {
                    user.draw++;
                }
                user.totalCount++;
                user.lastTimestamp = time;
                this.refreshUserRecord(user);
            }
            yield this.saveRealtime();
            this.setRankDirty();
        });
    }
    doCreateRoom(gameData) {
        return __awaiter(this, void 0, void 0, function* () {
            gameData = gameData || this.data.gameDatas[0];
            if (gameData == null) {
                return "没有找到玩法";
            }
            let roomFlag = "match|" + this.matchID;
            let roomData = null;
            try {
                roomData = yield rpc_1.Rpc.center.callException("kds.room.create.match", roomFlag, gameData, this.matchID);
                log_1.Log.oth.info("[match-custom] create room matchID = " + this.matchID + " | id = " + roomData.roomID);
            }
            catch (error) {
                log_1.Log.oth.error("[match-custom] create room failed gameData = ", gameData);
            }
            if (roomData == null) {
                return "创建失败";
            }
            this.addRoomID(roomData.roomID);
            let roomRealtime = yield rpc_1.Rpc.center.callException("kds.dbp.room.real.get", roomData.roomID);
            return roomRealtime;
        });
    }
    doJiesanRoom(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomRealtime = yield rpc_1.Rpc.center.callException("kds.dbp.room.real.get", roomID);
            if (roomRealtime == null) {
                return "房间不存在";
            }
            let b = false;
            if (roomRealtime.gsTag) {
                b = yield rpc_1.Rpc.center.callException("kds.srs.center.jiesanRoom", roomID);
            }
            else {
                b = yield rpc_1.Rpc.center.callException("kds.room.removeInternal", roomID);
            }
            if (!b) {
                return "解散失败";
            }
            return true;
        });
    }
    doUserEnterRoom(userID, roomID, watch) {
        return __awaiter(this, void 0, void 0, function* () {
            let roomRealtime = yield rpc_1.Rpc.center.callException("kds.dbp.room.real.get", roomID);
            if (roomRealtime == null) {
                return "房间不存在";
            }
            let chairNo = -1;
            if (watch) {
                if (roomRealtime.status != RoomDefine_1.RoomDefine.RoomStatusType.Running) {
                    return "房间还未开始，无法旁观";
                }
                //chairNo = RoomDefine.watchChairNoStart
            }
            let nodeName = yield GroupHelper_1.GroupHelper.getUserNodeName(userID);
            let b = yield rpc_1.Rpc.center.callException(SrsDefine_1.SrsInternal.getSrsNodeApiPrefix(nodeName) +
                ".userEnterRoomFromMatch", userID, this.matchID, roomID, chairNo);
            if (!b) {
                return "进入失败";
            }
            return true;
        });
    }
    doGetRooms() {
        return __awaiter(this, void 0, void 0, function* () {
            let kv = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gettAll", this._getGroupCacheTableName());
            if (kv) {
                let ret = [];
                let roomIDs = [];
                for (let key of Object.keys(kv)) {
                    roomIDs.push(Number.parseInt(key));
                }
                for (let roomID of roomIDs) {
                    let roomRealtime = yield rpc_1.Rpc.center.callException("kds.dbp.room.real.get", roomID);
                    if (roomRealtime) {
                        ret.push(roomRealtime);
                    }
                    else {
                        log_1.Log.oth.error("[match-custom] cannot get room realtime id = " + roomID);
                    }
                }
                return ret;
            }
            return [];
        });
    }
    _getGroupCacheTableName() {
        return "t_match_rooms_" + this.matchID;
    }
    addRoomID(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", this._getGroupCacheTableName(), roomID.toString(), true);
        });
    }
    removeRoomID(roomID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.delt", this._getGroupCacheTableName(), roomID.toString());
        });
    }
}
exports.MatchEx_CustomRoom = MatchEx_CustomRoom;
