"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchEx_FreeGroup = void 0;
const async_1 = require("kdweb-core/lib/tools/async");
const utils_1 = require("kdweb-core/lib/utils");
const log_1 = require("../../log");
const rpc_1 = require("../../rpc");
const MatchBase_1 = require("../MatchBase");
// 自由匹配
class MatchEx_FreeGroup extends MatchBase_1.MatchBase {
    // async userSignUp(userID:number) {
    // 	return "该比赛不能自己报名"
    // }
    loop_MatchStart() {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[match-free] match start");
            if (!utils_1.kdutils.isArray(this.data.startTimes)) {
                log_1.Log.oth.error("[match-free] match start failed time is null match id = " + this.matchID);
                this.doMatchEnd();
                return;
            }
            let times = this.data.startTimes[this.step];
            if (times == null) {
                return;
            }
            let time = utils_1.kdutils.getMillionSecond();
            let endTimestamp = times.endTimestamp;
            if (time >= endTimestamp) {
                return;
            }
            let b = rpc_1.Rpc.groupMgr.addGroupByMatch(this.data);
            if (!b) {
                log_1.Log.oth.error("[match-free] cannot create group entity match id = " + this.matchID);
                this.doMatchEnd();
                return;
            }
            log_1.Log.oth.info("[match-free] match start groupID = " + this.data.groupData.groupID + " | matchID = " + this.matchID);
            while (true) {
                let time = utils_1.kdutils.getMillionSecond();
                if (time >= endTimestamp) {
                    break;
                }
                yield async_1.kdasync.timeout(this.getTimeout(time, endTimestamp));
            }
            log_1.Log.oth.info("[match-free] match end groupID = " + this.data.groupData.groupID + " | matchID = " + this.matchID);
            //Rpc.groupMgr.removeGroupByMatch(this.data)
        });
    }
    onRelease() {
        const _super = Object.create(null, {
            onRelease: { get: () => super.onRelease }
        });
        return __awaiter(this, void 0, void 0, function* () {
            rpc_1.Rpc.groupMgr.removeGroupByMatch(this.data);
            _super.onRelease.call(this);
        });
    }
    loop_NextStep() {
        return __awaiter(this, void 0, void 0, function* () {
            return (this.step + 1) <= (this.data.startTimes.length - 1);
        });
    }
}
exports.MatchEx_FreeGroup = MatchEx_FreeGroup;
