"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Match_WanKeMode = exports.RoundEndType = void 0;
const GameSet_1 = require("../../../../kds-base-define/src/GameSet");
const log_1 = require("../../log");
const MatchEx_FreeGroup_1 = require("./MatchEx_FreeGroup");
const utils_1 = require("kdweb-core/lib/utils");
var RoundEndType;
(function (RoundEndType) {
    RoundEndType[RoundEndType["Normal"] = 0] = "Normal";
    RoundEndType[RoundEndType["Jiesan"] = 1] = "Jiesan";
    RoundEndType[RoundEndType["System"] = 2] = "System";
    RoundEndType[RoundEndType["Timeout"] = 3] = "Timeout";
    RoundEndType[RoundEndType["Offline"] = 4] = "Offline";
    RoundEndType[RoundEndType["Escape"] = 5] = "Escape";
})(RoundEndType = exports.RoundEndType || (exports.RoundEndType = {}));
class Match_WanKeMode extends MatchEx_FreeGroup_1.MatchEx_FreeGroup {
    loop_MatchStart() {
        const _super = Object.create(null, {
            loop_MatchStart: { get: () => super.loop_MatchStart }
        });
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[match-wanke] match start");
            // if(this.r.users.length < 4) {
            // 	return 
            // }
            return yield _super.loop_MatchStart.call(this);
        });
    }
    loop_WaitForRestart() {
        return __awaiter(this, void 0, void 0, function* () {
            return;
        });
    }
    loop_MatchRestart() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    onRoomEnd(roomPOData, roomRealtime, bill) {
        const _super = Object.create(null, {
            onRoomEnd: { get: () => super.onRoomEnd }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.onRoomEnd.call(this, roomPOData, roomRealtime, bill);
            if (bill == null) {
                return;
            }
            log_1.Log.oth.info("[match-wanke] onRoomEnd roomID = " + roomPOData.roomID);
            let runtime = bill.runtime;
            let userScores = [];
            let roomData = roomPOData.roomData;
            let gameData = roomData.gameData;
            let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
            for (let i = 0; i < gameSet.getUserCount(); i++) {
                let user = bill.users.find(v => v.chairNo == i);
                userScores.push({
                    userID: user.userID,
                    score: 0
                });
            }
            log_1.Log.oth.info(JSON.stringify(bill));
            if (runtime.roundEndType == "Jiesan") {
            }
            else if (runtime.roundEndType == "Escape") {
                let scores = bill.scores.slice(0);
                scores.sort((a, b) => a.score - b.score);
                let loser = scores[0];
                log_1.Log.oth.info(scores);
                log_1.Log.oth.info(loser);
                for (let chairNo = 0; chairNo < userScores.length; chairNo++) {
                    let userScore = userScores[chairNo];
                    if (chairNo == loser.chairNo) {
                        userScore.score -= 3 * gameSet.getScore();
                    }
                    else {
                        if (Math.abs(chairNo - loser.chairNo) == 2) {
                            userScore.score = 0;
                        }
                        else {
                            userScore.score += gameSet.getScore();
                        }
                    }
                }
            }
            else if (runtime.roundEndType == "Normal") {
                for (let chairNo = 0; chairNo < userScores.length; chairNo++) {
                    let userScore = userScores[chairNo];
                    let scoreInfo = bill.scores.find(v => v.chairNo == chairNo);
                    if (scoreInfo.score > 0) {
                        userScore.score += gameSet.getScore();
                    }
                    else {
                        userScore.score -= gameSet.getScore();
                    }
                }
            }
            let time = utils_1.kdutils.getMillionSecond();
            log_1.Log.oth.info("[match-wanke] calc result userScores =  ", userScores);
            for (let userScore of userScores) {
                let user = this.r.userRecords.find(v => v.userID == userScore.userID);
                user.score += userScore.score;
                if (userScore.score > 0) {
                    user.win++;
                }
                else if (userScore.score < 0) {
                    user.lose++;
                }
                else {
                    user.draw++;
                }
                user.totalCount++;
                user.lastTimestamp = time;
                this.refreshUserRecord(user);
                yield this.addUserScoreBill(userScore.userID, userScore.score, bill);
            }
            yield this.saveRealtime();
            this.setRankDirty();
        });
    }
}
exports.Match_WanKeMode = Match_WanKeMode;
