"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rpc = void 0;
const centerClient_1 = require("kdweb-core/lib/rpc/center/centerClient");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const config_1 = require("./config");
const GroupManager_1 = require("./group/GroupManager");
const group_1 = require("./rpc/group");
const user_1 = require("./rpc/user");
const NotifyDefine_1 = require("../../kds-base-define/src/NotifyDefine");
const notifyListen_1 = require("./rpc/notifyListen");
const room_1 = require("./rpc/room");
const MatchManager_1 = require("./match/MatchManager");
const MatchDefine_1 = require("../../kds-base-define/src/MatchDefine");
const Match_WanKeMode_1 = require("./match/entity/Match_WanKeMode");
const match_1 = require("./rpc/match");
const Match_ZhouShuiZi_1 = require("./match/entity/Match_ZhouShuiZi");
const Match_YWCircle_1 = require("./match/entity/Match_YWCircle");
const RobotManager_1 = require("./group/robot/RobotManager");
const Match_GaoXinSocial_1 = require("./match/entity/Match_GaoXinSocial");
var Rpc;
(function (Rpc) {
    Rpc.groupMgr = new GroupManager_1.GroupManager;
    Rpc.robotMgr = new RobotManager_1.RobotManager;
    Rpc.matchMgr = new MatchManager_1.MatchManager;
    function init() {
        if (ServerConfig_1.ServerValues.localIp) {
            centerClient_1.kdRpcCenterClient.setupLocalHostReplacement(ServerConfig_1.ServerValues.localIp);
        }
        Rpc.center = new centerClient_1.kdRpcCenterClient.entity({
            centerHost: ServerConfig_1.ServerValues.rpcCenterHost,
            port: config_1.Config.myConfig.wsPort,
            token: ServerConfig_1.ServerValues.rpcToken,
            info: {
                name: config_1.Config.myName,
                tag: config_1.Config.myName,
                host: config_1.Config.myConfig.wsHost,
                auth: "DDD",
                version: "1.0",
                timestamp: 0,
                data: null
            }
        });
        Rpc.center.logUrlPath = ServerConfig_1.ServerValues.rpcLoggerHost;
        Rpc.center.addGroup("kds.group", group_1.RpcGroupManager);
        Rpc.center.addGroup("kds.group.robot", group_1.RpcGroupRobot);
        Rpc.center.addGroup("kds.group.user", user_1.RpcGroupUser);
        Rpc.center.addGroup("kds.group.room", room_1.RpcGroupRoom);
        Rpc.center.addGroup("kds.match", match_1.RpcMatch);
        Rpc.center.addGroup("kds.match.user", match_1.RpcMatchUser);
        Rpc.center.addGroup("kds.match.admin", match_1.RpcAdminMatch);
        Rpc.center.addGroup("kds.match.config", match_1.RpcConfigMatch);
        Rpc.center.addGroup("kds.match.rank", match_1.RpcMatchRank);
        Rpc.center.addGroup("kds.match.reward", match_1.RpcMatchReward);
        Rpc.center.addGroup(NotifyDefine_1.NotifyDefine.ListenPrefix, notifyListen_1.RpcNTServiceListen);
    }
    Rpc.init = init;
})(Rpc = exports.Rpc || (exports.Rpc = {}));
Rpc.matchMgr.regModeClass(MatchDefine_1.MatchDefine.MatchMode.WanKe, Match_WanKeMode_1.Match_WanKeMode);
Rpc.matchMgr.regModeClass(MatchDefine_1.MatchDefine.MatchMode.ZhouShuiZi, Match_ZhouShuiZi_1.Match_ZhouShuiZi);
Rpc.matchMgr.regModeClass(MatchDefine_1.MatchDefine.MatchMode.YWCircle, Match_YWCircle_1.Match_YWCircle);
Rpc.matchMgr.regModeClass(MatchDefine_1.MatchDefine.MatchMode.GaoXinSocial, Match_GaoXinSocial_1.Match_GaoXinSocial);
