"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcGroupRobot = exports.RpcGroupManager = void 0;
const RoomDefine_1 = require("../../../kds-base-define/src/RoomDefine");
const MatchDefine_1 = require("../../../kds-base-define/src/MatchDefine");
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const GameSet_1 = require("../../../kds-base-define/src/GameSet");
// 创建匹配
function createGroup(h, groupData) {
    return __awaiter(this, void 0, void 0, function* () {
        groupData.groupID = yield rpc_1.Rpc.center.callException("kds.ids.getId", "group-id-ex", 67000000, 1);
        if (groupData.groupID == null) {
            return null;
        }
        groupData.createTimestamp = utils_1.kdutils.getMillionSecond();
        groupData.createDate = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
        let gameData = groupData.gameData;
        let gameSet = new GameSet_1.GameSet(gameData.gameID, gameData.bSets, gameData.iSets);
        gameSet.setDeskCost(groupData.roomCost);
        gameSet.setWinnerRate(groupData.winnerRate);
        gameSet.setScore(groupData.baseCost);
        switch (groupData.costType) {
            case MatchDefine_1.MatchDefine.CostType.Gold:
                {
                    gameSet.setPayType(RoomDefine_1.RoomDefine.PayType.CoinGame | RoomDefine_1.RoomDefine.PayType.UseGold);
                }
                break;
            case MatchDefine_1.MatchDefine.CostType.Diamond:
                {
                    gameSet.setPayType(RoomDefine_1.RoomDefine.PayType.CoinGame | RoomDefine_1.RoomDefine.PayType.UseDiamond);
                }
                break;
            case MatchDefine_1.MatchDefine.CostType.Item:
                {
                }
                break;
        }
        groupData.gameData = gameSet.gameData;
        let b = yield rpc_1.Rpc.center.callException("kds.dbp.group.add", groupData);
        if (b) {
            return groupData;
        }
        return null;
    });
}
function getGroup(h, groupID) {
    return __awaiter(this, void 0, void 0, function* () {
        let groupData = yield rpc_1.Rpc.center.callException("kds.dbp.group.get", groupID);
        if (groupData) {
            groupData.activeUserCount = rpc_1.Rpc.groupMgr.getGroupActiveUserCount(groupID);
        }
        return groupData;
    });
}
function removeGroup(h, groupID) {
    return __awaiter(this, void 0, void 0, function* () {
        yield rpc_1.Rpc.center.callException("kds.dbp.group.remove", groupID);
        rpc_1.Rpc.groupMgr.removeGroup(groupID);
        return true;
    });
}
function getAllGroups(h, gameID) {
    return __awaiter(this, void 0, void 0, function* () {
        let groupDatas = yield rpc_1.Rpc.center.callException("kds.dbp.group.getAll");
        let rets = [];
        if (groupDatas) {
            for (let groupData of groupDatas) {
                if (gameID != null) {
                    if (groupData.gameData.gameID != gameID) {
                        continue;
                    }
                }
                rets.push(groupData);
                groupData.activeUserCount = rpc_1.Rpc.groupMgr.getGroupActiveUserCount(groupData.groupID);
            }
        }
        return rets;
    });
}
function getUserCount(h, groupID) {
    return __awaiter(this, void 0, void 0, function* () {
        return rpc_1.Rpc.groupMgr.getGroupActiveUserCount(groupID);
    });
}
function getGameUserCount(h, gameID) {
    return __awaiter(this, void 0, void 0, function* () {
        return rpc_1.Rpc.groupMgr.getGroupGameActiveUserCount(gameID);
    });
}
function setRobotEnabled(h, groupID, b) {
    return __awaiter(this, void 0, void 0, function* () {
        return rpc_1.Rpc.groupMgr.setRobotEnabled(groupID, b);
    });
}
function getRobotEnabled(h, groupID, b) {
    return __awaiter(this, void 0, void 0, function* () {
        return rpc_1.Rpc.groupMgr.getRobotEnabled(groupID);
    });
}
exports.RpcGroupManager = {
    create: createGroup,
    get: getGroup,
    remove: removeGroup,
    getAll: getAllGroups,
    getUserCount: getUserCount,
    getGameUserCount: getGameUserCount
};
exports.RpcGroupRobot = {
    setEnabled: setRobotEnabled,
    getEnabled: getRobotEnabled,
};
