"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcAdminMatch = exports.RpcMatchReward = exports.RpcMatchRank = exports.RpcConfigMatch = exports.RpcMatchUser = exports.RpcMatch = void 0;
const MatchDefine_1 = require("../../../kds-base-define/src/MatchDefine");
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const log_1 = require("../log");
function addMatch(h, matchData) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.matchMgr.addMatch(matchData);
    });
}
function setMatchConfig(h, config) {
    return __awaiter(this, void 0, void 0, function* () {
        yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", "t_match_config", config.matchID.toString(), JSON.stringify(config));
        return true;
    });
}
function getMatchConfig(h, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", "t_match_config", matchID.toString());
        if (str) {
            return JSON.parse(str);
        }
        return null;
    });
}
// 2023/7/24 zhb修改后台管理获取每期参与比赛人数
function getUserSignUp(h, date) {
    return __awaiter(this, void 0, void 0, function* () {
        let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", "match_rank:match-count", date);
        if (str) {
            return JSON.parse(str);
        }
        return null;
    });
}
function getMatchData(h, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (match) {
            let data = utils_1.kdutils.clone(match.data);
            data.signupUserCount = match.r.users.length;
            data.step = match.r.count;
            return data;
        }
        return null;
    });
}
// 2023/7/25 zhb修改后台管理获取包含指定userid、matchid、createDate的数据
function getMatchRoomInfo(h, time, matchID, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = yield rpc_1.Rpc.matchMgr.getMatchInfo(time, matchID, userID);
        if (match) {
            return match;
        }
        return null;
    });
}
// 2023/7/26 zhb修改后台管理按日期获取比赛排行榜
function getMatchRankData(h, createDate, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = yield rpc_1.Rpc.matchMgr.getMatchRank(matchID, createDate);
        if (match) {
            return match;
        }
        return null;
    });
}
// 2023/7/26 zhb修改后台管理更新排行榜数据
function updateMatchRankData(h, createDate, matchID, matchData) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = yield rpc_1.Rpc.matchMgr.updateMatchRank(matchID, createDate, matchData);
        if (match) {
            return match;
        }
        return null;
    });
}
//zhb 修改为后台管理开比赛时清除排行榜数据
function removeMatchRankData(h, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.center.callException("kds.dbp.kv.c.del", MatchDefine_1.MatchDefine.getMatchRankChangedName(matchID));
    });
}
function removeMatch(h, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.matchMgr.removeMatch(matchID);
    });
}
function getAllMatches(h, gameID) {
    return __awaiter(this, void 0, void 0, function* () {
        let entities = rpc_1.Rpc.matchMgr.entities;
        let datas = [];
        for (let entity of entities) {
            if (!entity.alive) {
                continue;
            }
            let matchData = entity.data;
            if (gameID) {
                if (matchData.groupData) {
                    if (matchData.groupData.gameData.gameID != gameID) {
                        continue;
                    }
                }
                else {
                    if (matchData.gameDatas == null || matchData.gameDatas.length == 0) {
                        continue;
                    }
                    if (matchData.gameDatas.find(v => v.gameID == gameID) == null) {
                        continue;
                    }
                }
            }
            let data = utils_1.kdutils.clone(entity.data);
            data.signupUserCount = entity.r.users.length;
            data.step = entity.r.count;
            datas.push(data);
        }
        return datas;
    });
}
// 2023/5/25 zhb增加后台管理获取比赛列表
function getAdminAllMatches(h) {
    return __awaiter(this, void 0, void 0, function* () {
        let entities = yield rpc_1.Rpc.matchMgr.getAllMatch();
        return entities;
    });
}
// 2023/5/25 zhb增加后台管理获取比赛列表
function updateMatche(h, matchData) {
    return __awaiter(this, void 0, void 0, function* () {
        let entities = yield rpc_1.Rpc.matchMgr.updateMatch(matchData.matchID, matchData);
        return entities;
    });
}
function getRealtime(h, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (match) {
            return match.r;
        }
        return null;
    });
}
function getUserRank(h, matchID, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (match) {
            return yield match.getUserRank(userID);
        }
        return null;
    });
}
function userSignUp(h, matchID, userID, userInfo) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (match) {
            let ret = yield match.userSignUp(userID);
            if (typeof (ret) == "string") {
                return ret;
            }
            if (userInfo) {
                let ret = yield match.doSetUserInfo(userInfo);
                if (typeof (ret) == "string") {
                    return ret;
                }
            }
            return true;
        }
        return "比赛不存在";
    });
}
function userEnterMatch(h, matchID, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        let ret = {
            success: false,
            admin: false,
            signup: false,
        };
        if (match == null) {
            ret.errMsg = "比赛不存在";
            return ret;
        }
        let user = yield rpc_1.Rpc.matchMgr.getUserOfInBlackList(userID);
        if (user) {
            if (user.matchID == false || user.matchID == 0 || user.matchID === match.data.matchID) {
                let thisTime = utils_1.kdutils.getMillionSecond();
                let guoqi = user.createBanTime + (user.banTime * 86400000);
                if (thisTime >= user.createBanTime && thisTime <= guoqi) {
                    ret.errMsg = "您没有进入比赛的权限";
                    return ret;
                }
            }
        }
        if (match.r.admins.indexOf(userID) >= 0) {
            ret.success = true;
            ret.admin = true;
        }
        else {
            let signMode = match.data.signup & MatchDefine_1.MatchDefine.SignUpMode.FlagMode;
            if (signMode != MatchDefine_1.MatchDefine.SignUpMode.Admin) {
                ret.success = true;
            }
            if (match.r.users.indexOf(userID) >= 0) {
                ret.success = true;
                ret.signup = true;
            }
            else {
                if (match.data.signup & MatchDefine_1.MatchDefine.SignUpMode.NoSignUp) {
                    ret.success = true;
                }
            }
        }
        return ret;
    });
}
function userGetRooms(h, matchID, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.userGetRooms(userID) : [];
    });
}
function enterRoom(h, matchID, userID, roomID) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.userEnterRoom(userID, roomID) : "比赛不存在";
    });
}
function refreshRank(h, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (match) {
            yield match.onRefreshRank(true);
            return true;
        }
        return false;
    });
}
function getUserRecord(h, matchID, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.getUserRecord(userID) : "比赛不存在";
    });
}
function getUserScoreBill(h, matchID, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (match) {
            if (match.r.users.includes(userID)) {
                return yield match.getUserScoreBill(userID);
            }
        }
        return null;
    });
}
function giveRankReward(h, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (entity) {
            return yield entity.giveRankReward();
        }
        return "比赛未找到";
    });
}
// 2023/7/25 zhb修改后台管理下发比赛排行榜奖励
function adminGiveRankReward(h, data) {
    return __awaiter(this, void 0, void 0, function* () {
        log_1.Log.oth.info('match.ts => giveRankReward');
        if (!data.matchID) {
            return null;
        }
        return yield _adminGiveRankReward(data);
    });
}
function _adminGiveRankReward(data) {
    return __awaiter(this, void 0, void 0, function* () {
        let time = utils_1.kdutils.getMillionSecond();
        let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD", time);
        let rankRewards = data.rankRewards;
        let matchRank = data.ranks;
        let matchID = data.matchID;
        let rewardName = data.rewardName;
        let rewardTime = data.rewardTime;
        if (rankRewards && rankRewards.length > 0) {
            let maxCount = 0;
            for (let rewardInfo of rankRewards) {
                if (rewardInfo.toRank > maxCount) {
                    maxCount = rewardInfo.toRank;
                }
            }
            let ranks = matchRank;
            let i = 0;
            for (let info of ranks) {
                i++;
                let item;
                for (let tempItem of rankRewards) {
                    if (i >= tempItem.fromRank && i <= tempItem.toRank) {
                        item = tempItem;
                        break;
                    }
                }
                if (item) {
                    let userRewardItem = {
                        rewardID: null,
                        items: item.items,
                        timestamp: time,
                        date: date,
                        desc: getRankRewardDesc(info.userID, i, rewardName, rewardTime),
                        matchID: matchID,
                        gain: false,
                    };
                    log_1.Log.oth.info('_adminGiveRankReward userRewardItem => ', JSON.stringify(userRewardItem));
                    rpc_1.Rpc.matchMgr.addReward(info.userID, userRewardItem);
                }
            }
            return true;
        }
        return false;
    });
}
function getRankRewardDesc(userID, rankIdx, rewardName, rewardTime) {
    return rewardTime + " 第" + rankIdx + "名\n" + rewardName;
}
function getUserRewards(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.matchMgr.getRewards(userID);
    });
}
function gainUserReward(h, userID, rewardID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.matchMgr.gainRewards(userID, rewardID);
    });
}
// string or obj
function getRooms(h, matchID, admin) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.userGetRooms(admin) : "比赛不存在";
    });
}
// 2023/7/25 zhb修改后台管理增加删除玩家奖励
function delUserReward(h, userID, rewardID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.matchMgr.delRewards(userID, rewardID);
    });
}
// match
exports.RpcMatch = {
    add: addMatch,
    get: getMatchData,
    remove: removeMatch,
    getAll: getAllMatches,
    getRealtime: getRealtime,
    giveRankReward: giveRankReward,
    update: updateMatche,
    // 2023/5/25 zhb增加后台管理获取比赛列表
    getAdminAll: getAdminAllMatches,
    // 2023/6/27 zhb增加比赛结束后不自动清除排行榜数据
    removeRank: removeMatchRankData,
    // 2023/7/25 zhb修改后台管理获取包含指定userid、matchid、createDate的数据
    getMatchRoomInfo: getMatchRoomInfo,
    // 2023/7/26 zhb修改后台管理按日期获取比赛排行榜
    getMatchRankData: getMatchRankData,
    // 2023/7/26 zhb修改后台管理修改排行榜数据
    updateMatchRankData: updateMatchRankData,
    // 2023/7/26 zhb修改后台管理后台发放奖励
    adminGiveRankReward: adminGiveRankReward,
};
// match.user
exports.RpcMatchUser = {
    signup: userSignUp,
    getSignup: getUserSignUp,
    enter: userEnterMatch,
    enterRoom: enterRoom,
    getRooms: userGetRooms,
    getRecord: getUserRecord,
    getScoreBill: getUserScoreBill,
    userGetRooms: userGetRooms,
};
// match.config
exports.RpcConfigMatch = {
    set: setMatchConfig,
    get: getMatchConfig,
};
// match.rank
exports.RpcMatchRank = {
    refresh: refreshRank,
    user: getUserRank,
};
// match.reward 
exports.RpcMatchReward = {
    get: getUserRewards,
    gain: gainUserReward,
    // 2023/7/25 zhb修改后台管理增加删除玩家奖励
    del: delUserReward,
};
// string or true
function admin_SignUp(h, matchID, admin, userID, userInfo) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (entity) {
            let ret = yield entity.adminSignUp(admin, userID);
            if (typeof (ret) == "string") {
                return ret;
            }
            if (userInfo) {
                let ret = yield entity.adminSetUserInfo(admin, userInfo);
                if (typeof (ret) == "string") {
                    return ret;
                }
            }
            return true;
        }
        return "比赛不存在";
    });
}
function admin_UnSignUp(h, matchID, admin, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let match = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        if (match) {
            return yield match.adminUnSignUp(admin, userID);
        }
        return "比赛不存在";
    });
}
// string or obj
function admin_GetMatchRealtime(h, matchID, admin) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.adminGetRealtime(admin) : "比赛不存在";
    });
}
// string or obj
function admin_GetMatchUserInfo(h, matchID, admin, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.adminGetUserInfo(admin, userID) : "比赛不存在";
    });
}
// string or obj
function admin_GetMatchAllUserInfos(h, matchID, admin) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.adminGetAllUserInfos(admin) : "比赛不存在";
    });
}
// string or boolean
function admin_SetMatchUserInfo(h, matchID, admin, userInfo) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.adminSetUserInfo(admin, userInfo) : "比赛不存在";
    });
}
// string or obj
function admin_GetRooms(h, matchID, admin) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.adminGetRooms(admin) : "比赛不存在";
    });
}
function admin_CreateRoom(h, matchID, admin, gameData) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.adminCreateRoom(admin, 1, gameData) : "比赛不存在";
    });
}
function admin_JiesanRoom(h, matchID, admin, roomID) {
    return __awaiter(this, void 0, void 0, function* () {
        let entity = rpc_1.Rpc.matchMgr.getMatchEntity(matchID);
        return entity != null ? yield entity.adminJiesanRoom(admin, roomID) : "比赛不存在";
    });
}
exports.RpcAdminMatch = {
    signup: admin_SignUp,
    unsignup: admin_UnSignUp,
    getRealtime: admin_GetMatchRealtime,
    getUserInfo: admin_GetMatchUserInfo,
    getAllUserInfos: admin_GetMatchAllUserInfos,
    setUserInfo: admin_SetMatchUserInfo,
    getRooms: admin_GetRooms,
    createRoom: admin_CreateRoom,
    jiesanRoom: admin_JiesanRoom,
};
