"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcGroupRoom = void 0;
const log_1 = require("../log");
const rpc_1 = require("../rpc");
function roomEnd(h, roomPOData, roomRealtime, bill) {
    return __awaiter(this, void 0, void 0, function* () {
        log_1.Log.oth.info("进入到roomEnd =>", JSON.stringify(roomPOData));
        let roomData = roomPOData.roomData;
        if (roomData.matchID) {
            let entity = rpc_1.Rpc.matchMgr.getMatchEntity(roomData.matchID);
            if (entity == null) {
                log_1.Log.oth.info("[roomEnd] cannot get match entity", bill);
                return;
            }
            yield entity.onRoomEnd(roomPOData, roomRealtime, bill);
        }
        else if (roomData.groupID) {
            let entity = yield rpc_1.Rpc.groupMgr.getGroupEntity(roomData.groupID);
            if (entity) {
                yield entity.onRoomEnd(roomPOData, roomRealtime, bill);
            }
        }
    });
}
exports.RpcGroupRoom = {
    end: roomEnd
};
