"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RpcGroupUser = void 0;
const rpc_1 = require("../rpc");
// srs主动调用
function srsUserEnter(h, loginData, groupID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.groupMgr.srsUserEnter(h, loginData, groupID);
    });
}
// srs主动调用，不需要通知srs
function srsUserExit(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.groupMgr.srsUserExit(h, userID);
    });
}
// 玩家调用
function userExit(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.groupMgr.userExit(userID);
    });
}
function getGroupID(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.groupMgr.getUserGroupID(userID);
    });
}
function srsUserConfirm(h, userID, b) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield rpc_1.Rpc.groupMgr.srsUserConfirm(userID, b);
    });
}
exports.RpcGroupUser = {
    enter: srsUserEnter,
    exit: srsUserExit,
    userExit: userExit,
    get: getGroupID,
    confirm: srsUserConfirm
};
